/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.launch.launching;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.oprofile.core.daemon.OprofileDaemonEvent;
import org.eclipse.linuxtools.oprofile.launch.OprofileLaunchMessages;
import org.eclipse.linuxtools.oprofile.launch.configuration.LaunchOptions;
import org.eclipse.linuxtools.oprofile.launch.launching.AbstractOprofileLaunchConfigurationDelegate;
import org.eclipse.linuxtools.oprofile.ui.view.OprofileViewSaveDefaultSessionAction;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OprofileManualLaunchConfigurationDelegate
extends AbstractOprofileLaunchConfigurationDelegate {
    protected boolean preExec(LaunchOptions options, OprofileDaemonEvent[] daemonEvents) {
        return true;
    }

    protected void postExec(LaunchOptions options, OprofileDaemonEvent[] daemonEvents, ILaunch launch, Process process) {
        final LaunchOptions fOptions = options;
        final OprofileDaemonEvent[] fDaemonEvents = daemonEvents;
        final ILaunch fLaunch = launch;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    if (!OprofileManualLaunchConfigurationDelegate.this.oprofileStatus()) {
                        return;
                    }
                    OprofileManualLaunchConfigurationDelegate.this.oprofileReset();
                    OprofileManualLaunchConfigurationDelegate.this.oprofileSetupDaemon(fOptions.getOprofileDaemonOptions(), fDaemonEvents);
                }
                catch (OpcontrolException oe) {
                    OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)((Object)oe));
                    return;
                }
                OprofiledControlDialog dlg = new OprofiledControlDialog();
                ILaunchManager lmgr = DebugPlugin.getDefault().getLaunchManager();
                if (!fLaunch.isTerminated()) {
                    dlg.setBlockOnOpen(false);
                    dlg.open();
                    lmgr.addLaunchListener((ILaunchesListener)new LaunchTerminationDialogCloser(fLaunch, dlg));
                }
            }
        });
    }

    public String generateCommand(ILaunchConfiguration config) {
        return null;
    }

    class LaunchTerminationDialogCloser
    implements ILaunchesListener2 {
        private ILaunch launch;
        private OprofiledControlDialog dialog;

        public LaunchTerminationDialogCloser(ILaunch il, OprofiledControlDialog dlg) {
            this.launch = il;
            this.dialog = dlg;
        }

        public void launchesTerminated(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch l = iLaunchArray[n2];
                if (l.equals(this.launch)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            LaunchTerminationDialogCloser.this.dialog.close();
                            IRunnableWithProgress refreshRunner = new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    monitor.beginTask(OprofileLaunchMessages.getString("oprofiledcontroldialog.post.stopdaemon"), 1);
                                    try {
                                        OprofileManualLaunchConfigurationDelegate.this.oprofileShutdown();
                                    }
                                    catch (OpcontrolException opcontrolException) {}
                                    monitor.worked(1);
                                    monitor.done();
                                }
                            };
                            ProgressMonitorDialog dialog = new ProgressMonitorDialog(null);
                            try {
                                dialog.run(true, false, refreshRunner);
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                ++n2;
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }
    }

    private class OprofiledControlDialog
    extends MessageDialog {
        private Button _startDaemonButton;
        private Button _stopDaemonButton;
        private Button _refreshViewButton;
        private Button _resetSessionButton;
        private Button _saveSessionButton;
        private List _feedbackList;

        public OprofiledControlDialog() {
            super(new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()), OprofileLaunchMessages.getString("oprofiledcontroldialog.title"), null, null, 0, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.setShellStyle(96);
        }

        protected Control createCustomArea(Composite parent) {
            Composite area = new Composite(parent, 0);
            GridLayout layout = new GridLayout(5, true);
            GridData gd = new GridData();
            area.setLayout((Layout)layout);
            area.setLayoutData((Object)gd);
            Button startDaemonButton = new Button(area, 8);
            startDaemonButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            startDaemonButton.setText(OprofileLaunchMessages.getString("oprofiledcontroldialog.buttons.startdaemon"));
            startDaemonButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        OprofileManualLaunchConfigurationDelegate.this.oprofileStartCollection();
                        OprofiledControlDialog.this._startDaemonButton.setEnabled(false);
                        OprofiledControlDialog.this._stopDaemonButton.setEnabled(true);
                        OprofiledControlDialog.this._refreshViewButton.setEnabled(true);
                        OprofiledControlDialog.this._resetSessionButton.setEnabled(true);
                        OprofiledControlDialog.this._saveSessionButton.setEnabled(true);
                    }
                    catch (OpcontrolException oe) {
                        OprofiledControlDialog.this.disableAllButtons();
                        OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)((Object)oe));
                    }
                    OprofiledControlDialog.this.addToFeedbackList(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.startdaemon"));
                }
            });
            this._startDaemonButton = startDaemonButton;
            Button stopDaemonButton = new Button(area, 8);
            stopDaemonButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            stopDaemonButton.setText(OprofileLaunchMessages.getString("oprofiledcontroldialog.buttons.stopdaemon"));
            stopDaemonButton.setEnabled(false);
            stopDaemonButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        OprofileManualLaunchConfigurationDelegate.this.oprofileShutdown();
                        OprofiledControlDialog.this._startDaemonButton.setEnabled(true);
                        OprofiledControlDialog.this._stopDaemonButton.setEnabled(false);
                    }
                    catch (OpcontrolException oe) {
                        OprofiledControlDialog.this.disableAllButtons();
                        OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)((Object)oe));
                    }
                    OprofiledControlDialog.this.addToFeedbackList(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.stopdaemon"));
                }
            });
            this._stopDaemonButton = stopDaemonButton;
            Button saveSessionButton = new Button(area, 8);
            saveSessionButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            saveSessionButton.setText(OprofileLaunchMessages.getString("oprofiledcontroldialog.buttons.savesession"));
            saveSessionButton.setEnabled(false);
            saveSessionButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    OprofiledControlDialog.this.addToFeedbackList(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.save"));
                    OprofileViewSaveDefaultSessionAction hack = new OprofileViewSaveDefaultSessionAction();
                    hack.run();
                }
            });
            this._saveSessionButton = saveSessionButton;
            Button resetSessionButton = new Button(area, 8);
            resetSessionButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            resetSessionButton.setText(OprofileLaunchMessages.getString("oprofiledcontroldialog.buttons.resetsession"));
            resetSessionButton.setEnabled(false);
            resetSessionButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        OprofileManualLaunchConfigurationDelegate.this.oprofileReset();
                    }
                    catch (OpcontrolException oe) {
                        OprofiledControlDialog.this.disableAllButtons();
                        OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)((Object)oe));
                    }
                    OprofileManualLaunchConfigurationDelegate.this.refreshOprofileView();
                    OprofiledControlDialog.this.addToFeedbackList(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.reset"));
                }
            });
            this._resetSessionButton = resetSessionButton;
            Button refreshViewButton = new Button(area, 8);
            refreshViewButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            refreshViewButton.setText(OprofileLaunchMessages.getString("oprofiledcontroldialog.buttons.refreshview"));
            refreshViewButton.setEnabled(false);
            refreshViewButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    OprofiledControlDialog.this.addToFeedbackList(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.dumpsamples"));
                    try {
                        OprofileManualLaunchConfigurationDelegate.this.oprofileDumpSamples();
                    }
                    catch (OpcontrolException opcontrolException) {}
                    OprofileManualLaunchConfigurationDelegate.this.refreshOprofileView();
                    OprofiledControlDialog.this.addToFeedbackList(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.refreshed"));
                }
            });
            this._refreshViewButton = refreshViewButton;
            List feedback = new List(area, 2570);
            feedback.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
            feedback.add(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.init"));
            this._feedbackList = feedback;
            return area;
        }

        private void disableAllButtons() {
            this._startDaemonButton.setEnabled(false);
            this._stopDaemonButton.setEnabled(false);
            this._refreshViewButton.setEnabled(false);
            this._resetSessionButton.setEnabled(false);
            this._saveSessionButton.setEnabled(false);
        }

        private void addToFeedbackList(String s) {
            this._feedbackList.add(s, 0);
            this._feedbackList.setTopIndex(0);
        }
    }
}

