/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.markers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.rpm.ui.editor.markers.SpecfileMarkerHandler;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParseException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class SpecfileErrorHandler
extends SpecfileMarkerHandler {
    public static final String SPECFILE_ERROR_MARKER_ID = "org.eclipse.linuxtools.rpm.ui.editor.specfileerror";
    public static final String ANNOTATION_ERROR = "org.eclipse.ui.workbench.texteditor.error";
    public static final String ANNOTATION_WARNING = "org.eclipse.ui.workbench.texteditor.warning";
    public static final String ANNOTATION_INFO = "org.eclipse.ui.workbench.texteditor.info";
    private Map<Position, Annotation> annotations = new HashMap<Position, Annotation>();
    private AnnotationModel fAnnotationModel;
    private IEditorInput input;

    public SpecfileErrorHandler(IEditorInput input, IDocument document) {
        super(null, document);
        this.input = input;
    }

    public void handleError(SpecfileParseException e) {
        int lineNumber = e.getLineNumber();
        int lineOffset = 0;
        try {
            lineOffset = this.document.getLineOffset(lineNumber);
        }
        catch (BadLocationException badLocationException) {}
        Integer charStart = new Integer(lineOffset + e.getStartColumn());
        Integer charEnd = new Integer(lineOffset + e.getEndColumn());
        String annotationType = ANNOTATION_INFO;
        if (e.getSeverity() == 2) {
            annotationType = ANNOTATION_ERROR;
        } else if (e.getSeverity() == 1) {
            annotationType = ANNOTATION_WARNING;
        }
        SpecfileAnnotation annotation = new SpecfileAnnotation(annotationType, true, e.getLocalizedMessage());
        Position p = new Position(charStart.intValue(), charEnd - charStart);
        this.fAnnotationModel.addAnnotation((Annotation)annotation, p);
        this.annotations.put(p, annotation);
    }

    public void removeAllExistingMarkers() {
        this.fAnnotationModel.removeAllAnnotations();
        this.annotations.clear();
    }

    public void removeExistingMarkers() {
        this.removeExistingMarkers(0, this.document.getLength());
    }

    private AnnotationModel getAnnotationModel() {
        return (AnnotationModel)SpecfileEditor.getSpecfileDocumentProvider().getAnnotationModel(this.input);
    }

    public void removeExistingMarkers(int offset, int length) {
        this.fAnnotationModel = this.getAnnotationModel();
        Iterator i = this.fAnnotationModel.getAnnotationIterator();
        while (i.hasNext()) {
            Annotation annotation = (Annotation)i.next();
            Position p = this.fAnnotationModel.getPosition(annotation);
            int pStart = p.getOffset();
            if (pStart < offset || pStart >= offset + length) continue;
            this.fAnnotationModel.removeAnnotation(annotation);
        }
    }

    public SpecfileErrorHandler(IFile file, IDocument document) {
        this((IEditorInput)new FileEditorInput(file), document);
    }

    public void setFile(IFile file) {
        this.input = new FileEditorInput(file);
    }

    String getMarkerID() {
        return SPECFILE_ERROR_MARKER_ID;
    }

    private class SpecfileAnnotation
    extends Annotation
    implements IQuickFixableAnnotation {
        private boolean fIsQuickFixable;
        private boolean fIsQuickFixableStateSet;

        public SpecfileAnnotation(String annotationType, boolean persist, String message) {
            super(annotationType, persist, message);
        }

        public void setQuickFixable(boolean state) {
            this.fIsQuickFixable = state;
            this.fIsQuickFixableStateSet = true;
        }

        public boolean isQuickFixableStateSet() {
            return this.fIsQuickFixableStateSet;
        }

        public boolean isQuickFixable() {
            Assert.isTrue((boolean)this.isQuickFixableStateSet());
            return this.fIsQuickFixable;
        }
    }
}

