/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.rpm.ui.Messages;
import org.eclipse.linuxtools.rpm.ui.RPMExportOperation;
import org.eclipse.linuxtools.rpm.ui.RPMExportPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class RPMExportWizard
extends Wizard
implements IExportWizard {
    private RPMExportPage mainPage;
    private IStructuredSelection selection;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString("RPMExportWizard.Export_an_SRPM"));
        this.selection = currentSelection;
    }

    public boolean performFinish() {
        RPMExportOperation rpmExport = new RPMExportOperation(this.mainPage.getSelectedRPMProject(), this.mainPage.getExportType());
        rpmExport.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().equals(Status.OK_STATUS)) {
                    event.getResult();
                    System.out.println(RPMExportWizard.this.mainPage.getSelectedRPMProject().getMissingDependencies());
                }
            }
        });
        rpmExport.setUser(true);
        rpmExport.schedule();
        return true;
    }

    public boolean canFinish() {
        return this.mainPage.canFinish();
    }

    public void addPages() {
        IProject project = null;
        if (!this.selection.isEmpty()) {
            if (!(this.selection.getFirstElement() instanceof IProject)) {
                if (this.selection.getFirstElement() instanceof IResource) {
                    IResource resource = (IResource)this.selection.getFirstElement();
                    IProject parentProject = resource.getProject();
                    try {
                        if (parentProject.hasNature("org.eclipse.linuxtools.rpm.core.rpmnature")) {
                            project = parentProject;
                        }
                    }
                    catch (CoreException coreException) {}
                }
            } else if (this.selection.getFirstElement() instanceof IProject) {
                IProject tempProject = (IProject)this.selection.getFirstElement();
                try {
                    if (tempProject.hasNature("org.eclipse.linuxtools.rpm.core.rpmnature")) {
                        project = tempProject;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        this.mainPage = new RPMExportPage(project);
        this.addPage((IWizardPage)this.mainPage);
    }
}

