/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.editors;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.tmf.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfTraceParserUpdatedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditor;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.parsers.ParserProviderManager;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.linuxtools.tmf.ui.views.project.ProjectView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class TmfEventsEditor
extends TmfEditor
implements ITmfTraceEditor,
IReusableEditor,
IPropertyListener {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.editors.events";
    private TmfEventsTable fEventsTable;
    private IResource fResource;
    private ITmfTrace fTrace;
    private Composite fParent;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof TmfEditorInput) {
            this.fResource = ((TmfEditorInput)input).getResource();
            this.fTrace = ((TmfEditorInput)input).getTrace();
        } else if (input instanceof IFileEditorInput) {
            this.fResource = ((IFileEditorInput)input).getFile();
            this.fTrace = ParserProviderManager.getTrace(this.fResource);
            input = new TmfEditorInput(this.fResource, this.fTrace);
        } else if (input instanceof FileStoreEditorInput) {
            try {
                FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)input;
                this.fResource = ProjectView.createLink(fileStoreEditorInput.getURI());
                this.fTrace = ParserProviderManager.getTrace(this.fResource);
                input = new TmfEditorInput(this.fResource, this.fTrace);
            }
            catch (CoreException e) {
                throw new PartInitException(e.getMessage());
            }
        } else {
            throw new PartInitException("Invalid IEditorInput: " + input.getClass());
        }
        if (this.fTrace == null) {
            throw new PartInitException("Invalid IEditorInput: " + this.fResource.getName());
        }
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.firePropertyChange(258);
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 258) {
            this.broadcast((TmfSignal)new TmfTraceClosedSignal((Object)this, this.fTrace));
            this.fResource = ((TmfEditorInput)this.getEditorInput()).getResource();
            this.fTrace = ((TmfEditorInput)this.getEditorInput()).getTrace();
            this.fEventsTable.dispose();
            if (this.fTrace != null) {
                this.fEventsTable = this.createEventsTable(this.fParent, this.fTrace.getCacheSize());
                this.fEventsTable.setTrace(this.fTrace, true);
                this.broadcast((TmfSignal)new TmfTraceOpenedSignal((Object)this, this.fTrace));
            } else {
                this.fEventsTable = new TmfEventsTable(this.fParent, 0);
            }
            this.fParent.layout();
        }
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.setPartName(this.getEditorInput().getName());
        if (this.fTrace != null) {
            this.fEventsTable = this.createEventsTable(parent, this.fTrace.getCacheSize());
            this.fEventsTable.setTrace(this.fTrace, true);
            this.broadcast((TmfSignal)new TmfTraceOpenedSignal((Object)this, this.fTrace));
        } else {
            this.fEventsTable = new TmfEventsTable(parent, 0);
        }
        this.addPropertyListener(this);
    }

    @Override
    public void dispose() {
        this.removePropertyListener(this);
        if (this.fTrace != null) {
            this.broadcast((TmfSignal)new TmfTraceClosedSignal((Object)this, this.fTrace));
        }
        if (this.fEventsTable != null) {
            this.fEventsTable.dispose();
        }
        super.dispose();
    }

    protected TmfEventsTable createEventsTable(Composite parent, int cacheSize) {
        TmfEventsTable eventsTable = ParserProviderManager.getEventsTable(this.fTrace, parent, cacheSize);
        if (eventsTable == null) {
            eventsTable = new TmfEventsTable(parent, cacheSize);
        }
        return eventsTable;
    }

    @Override
    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public void setFocus() {
        this.fEventsTable.setFocus();
        if (this.fTrace != null) {
            this.broadcast((TmfSignal)new TmfTraceSelectedSignal((Object)this, this.fTrace));
        }
    }

    @TmfSignalHandler
    public void traceParserUpdated(TmfTraceParserUpdatedSignal signal) {
        if (signal.getTraceResource().equals((Object)this.fResource)) {
            this.broadcast((TmfSignal)new TmfTraceClosedSignal((Object)this, this.fTrace));
            this.fTrace = ParserProviderManager.getTrace(this.fResource);
            this.fEventsTable.dispose();
            if (this.fTrace != null) {
                this.fEventsTable = this.createEventsTable(this.fParent, this.fTrace.getCacheSize());
                this.fEventsTable.setTrace(this.fTrace, true);
                this.broadcast((TmfSignal)new TmfTraceOpenedSignal((Object)this, this.fTrace));
            } else {
                this.fEventsTable = new TmfEventsTable(this.fParent, 0);
            }
            this.fParent.layout();
        }
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getSource() != this && signal.getTrace().equals(this.fTrace)) {
            this.getSite().getPage().bringToTop((IWorkbenchPart)this);
        }
    }
}

