/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.parsers.custom;

import java.io.FileNotFoundException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.parsers.IParserProvider;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomEventsTable;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTxtTrace;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomXmlTrace;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.swt.widgets.Composite;

public class CustomParserProvider
implements IParserProvider {
    @Override
    public String getCategory() {
        return "Custom";
    }

    @Override
    public ITmfTrace getTraceForParser(String parser, IResource resource) {
        try {
            CustomTraceDefinition def;
            String name = resource.getName();
            String path = resource.getLocation().toOSString();
            CustomTraceDefinition[] customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
            int n = customTraceDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                def = customTraceDefinitionArray[n2];
                if (parser.equals(String.valueOf(CustomTxtTrace.class.getCanonicalName()) + "." + def.definitionName)) {
                    return new CustomTxtTrace(name, (CustomTxtTraceDefinition)def, path, 100);
                }
                ++n2;
            }
            customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
            n = customTraceDefinitionArray.length;
            n2 = 0;
            while (n2 < n) {
                def = customTraceDefinitionArray[n2];
                if (parser.equals(String.valueOf(CustomXmlTrace.class.getCanonicalName()) + "." + ((CustomXmlTraceDefinition)def).definitionName)) {
                    return new CustomXmlTrace(name, (CustomXmlTraceDefinition)def, path, 100);
                }
                ++n2;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ITmfTrace getTraceForContentType(String contentTypeId, IResource resource) {
        return null;
    }

    @Override
    public String getEditorIdForParser(String parser) {
        return null;
    }

    @Override
    public Map<String, String> getParserMap() {
        CustomTraceDefinition def;
        LinkedHashMap<String, String> parserMap = new LinkedHashMap<String, String>();
        CustomTraceDefinition[] customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
        int n = customTraceDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            def = customTraceDefinitionArray[n2];
            parserMap.put(def.definitionName, String.valueOf(CustomTxtTrace.class.getCanonicalName()) + "." + def.definitionName);
            ++n2;
        }
        customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
        n = customTraceDefinitionArray.length;
        n2 = 0;
        while (n2 < n) {
            def = customTraceDefinitionArray[n2];
            parserMap.put(((CustomXmlTraceDefinition)def).definitionName, String.valueOf(CustomXmlTrace.class.getCanonicalName()) + "." + ((CustomXmlTraceDefinition)def).definitionName);
            ++n2;
        }
        return parserMap;
    }

    @Override
    public TmfEventsTable getEventsTable(ITmfTrace trace, Composite parent, int cacheSize) {
        if (trace instanceof CustomTxtTrace) {
            return new CustomEventsTable(((CustomTxtTrace)trace).getDefinition(), parent, cacheSize);
        }
        if (trace instanceof CustomXmlTrace) {
            return new CustomEventsTable(((CustomXmlTrace)trace).getDefinition(), parent, cacheSize);
        }
        return null;
    }
}

