/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.events;

import org.eclipse.linuxtools.tmf.component.ITmfDataProvider;
import org.eclipse.linuxtools.tmf.component.TmfComponent;
import org.eclipse.linuxtools.tmf.event.TmfData;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.TmfDataRequest;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentUpdatedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.viewers.events.Messages;
import org.eclipse.linuxtools.tmf.ui.widgets.ColumnData;
import org.eclipse.linuxtools.tmf.ui.widgets.TmfVirtualTable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TmfEventsTable
extends TmfComponent {
    protected TmfVirtualTable fTable;
    protected ITmfTrace fTrace;
    protected boolean fPackDone = false;
    private static final String[] COLUMN_NAMES = new String[]{Messages.TmfEventsTable_TimestampColumnHeader, Messages.TmfEventsTable_SourceColumnHeader, Messages.TmfEventsTable_TypeColumnHeader, Messages.TmfEventsTable_ReferenceColumnHeader, Messages.TmfEventsTable_ContentColumnHeader};
    private static ColumnData[] COLUMN_DATA = new ColumnData[]{new ColumnData(COLUMN_NAMES[0], 100, 16384), new ColumnData(COLUMN_NAMES[1], 100, 16384), new ColumnData(COLUMN_NAMES[2], 100, 16384), new ColumnData(COLUMN_NAMES[3], 100, 16384), new ColumnData(COLUMN_NAMES[4], 100, 16384)};
    private final int fCacheSize;
    private TmfEvent[] fCache;
    private int fCacheStartIndex = 0;
    private int fCacheEndIndex = 0;
    private boolean fDisposeOnClose;
    private boolean fRefreshPending = false;

    public TmfEventsTable(Composite parent, int cacheSize) {
        this(parent, cacheSize, COLUMN_DATA);
    }

    public TmfEventsTable(Composite parent, int cacheSize, ColumnData[] columnData) {
        super("TmfEventsTable");
        this.fCacheSize = cacheSize;
        this.fCache = new TmfEvent[this.fCacheSize];
        this.fTable = new TmfVirtualTable(parent, 67588);
        GridData layoutData = new GridData(4, 4, true, true);
        this.fTable.setLayoutData(layoutData);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        this.setColumnHeaders(columnData);
        this.fTable.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TmfTimestamp ts = (TmfTimestamp)TmfEventsTable.this.fTable.getSelection()[0].getData();
                TmfEventsTable.this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)TmfEventsTable.this.fTable, ts));
            }
        });
        this.fTable.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                int index = TmfEventsTable.this.fTable.indexOf(item);
                if (index >= TmfEventsTable.this.fCacheStartIndex && index < TmfEventsTable.this.fCacheEndIndex) {
                    int i = index - TmfEventsTable.this.fCacheStartIndex;
                    item.setText(TmfEventsTable.this.extractItemFields(TmfEventsTable.this.fCache[i]));
                    item.setData((Object)new TmfTimestamp(TmfEventsTable.this.fCache[i].getTimestamp()));
                    return;
                }
                TmfEventsTable.this.fCacheStartIndex = index;
                TmfEventsTable.this.fCacheEndIndex = index;
                TmfDataRequest<TmfEvent> request = new TmfDataRequest<TmfEvent>(TmfEvent.class, index, TmfEventsTable.this.fCacheSize){
                    private int count;
                    {
                        this.count = 0;
                    }

                    public void handleData(TmfEvent event) {
                        super.handleData((TmfData)event);
                        if (event != null) {
                            ((TmfEventsTable)(this).TmfEventsTable.this).fCache[this.count++] = event.clone();
                            TmfEventsTable tmfEventsTable = TmfEventsTable.this;
                            tmfEventsTable.fCacheEndIndex = tmfEventsTable.fCacheEndIndex + 1;
                        }
                    }
                };
                ((ITmfDataProvider)TmfEventsTable.this.fTrace).sendRequest((ITmfDataRequest)request);
                try {
                    request.waitForCompletion();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (TmfEventsTable.this.fCache[0] != null && TmfEventsTable.this.fCacheStartIndex == index) {
                    item.setText(TmfEventsTable.this.extractItemFields(TmfEventsTable.this.fCache[0]));
                    item.setData((Object)new TmfTimestamp(TmfEventsTable.this.fCache[0].getTimestamp()));
                    TmfEventsTable.this.packColumns();
                }
            }
        });
        this.fTable.setItemCount(0);
    }

    public void dispose() {
        this.fTable.dispose();
        if (this.fTrace != null && this.fDisposeOnClose) {
            this.fTrace.dispose();
        }
        super.dispose();
    }

    public TmfVirtualTable getTable() {
        return this.fTable;
    }

    protected void setColumnHeaders(ColumnData[] columnData) {
        this.fTable.setColumnHeaders(columnData);
    }

    protected void packColumns() {
        if (this.fPackDone) {
            return;
        }
        TableColumn[] tableColumnArray = this.fTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            int headerWidth = column.getWidth();
            column.pack();
            if (column.getWidth() < headerWidth) {
                column.setWidth(headerWidth);
            }
            ++n2;
        }
        this.fPackDone = true;
    }

    protected String[] extractItemFields(TmfEvent event) {
        String[] fields = new String[]{};
        if (event != null) {
            fields = new String[]{new Long(event.getTimestamp().getValue()).toString(), event.getSource().getSourceId().toString(), event.getType().getTypeId().toString(), event.getReference().getReference().toString(), event.getContent().toString()};
        }
        return fields;
    }

    public void setFocus() {
        this.fTable.setFocus();
    }

    public void setTrace(ITmfTrace trace, boolean disposeOnClose) {
        if (this.fTrace != null && this.fDisposeOnClose) {
            this.fTrace.dispose();
        }
        this.fTrace = trace;
        this.fDisposeOnClose = disposeOnClose;
        this.fTable.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TmfEventsTable.this.fTable.removeAll();
                TmfEventsTable.this.fCacheEndIndex = 0;
                TmfEventsTable.this.fCacheStartIndex = 0;
                if (!TmfEventsTable.this.fTable.isDisposed() && TmfEventsTable.this.fTrace != null) {
                    TmfEventsTable.this.fTable.setItemCount((int)TmfEventsTable.this.fTrace.getNbEvents());
                }
            }
        });
    }

    @TmfSignalHandler
    public void experimentUpdated(TmfExperimentUpdatedSignal signal) {
        if (signal.getExperiment() != this.fTrace || this.fTable.isDisposed()) {
            return;
        }
        this.fTable.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!TmfEventsTable.this.fTable.isDisposed() && TmfEventsTable.this.fTrace != null) {
                    TmfEventsTable.this.fTable.setItemCount((int)TmfEventsTable.this.fTrace.getNbEvents());
                    TmfEventsTable.this.fTable.refresh();
                }
            }
        });
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (signal.getTrace() != this.fTrace || this.fTable.isDisposed()) {
            return;
        }
        this.fTable.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!TmfEventsTable.this.fTable.isDisposed() && TmfEventsTable.this.fTrace != null) {
                    TmfEventsTable.this.fTable.setItemCount((int)TmfEventsTable.this.fTrace.getNbEvents());
                }
            }
        });
    }

    @TmfSignalHandler
    public synchronized void rangeSynched(TmfRangeSynchSignal signal) {
        if (!this.fRefreshPending && !this.fTable.isDisposed()) {
            this.fRefreshPending = true;
            this.fTable.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TmfEventsTable.this.fRefreshPending = false;
                    if (!TmfEventsTable.this.fTable.isDisposed() && TmfEventsTable.this.fTrace != null) {
                        TmfEventsTable.this.fTable.setItemCount((int)TmfEventsTable.this.fTrace.getNbEvents());
                    }
                }
            });
        }
    }

    @TmfSignalHandler
    public void currentTimeUpdated(final TmfTimeSynchSignal signal) {
        if (signal.getSource() != this.fTable && this.fTrace != null && !this.fTable.isDisposed()) {
            TmfDataRequest<TmfEvent> subRequest = new TmfDataRequest<TmfEvent>(TmfEvent.class, 0, 1, ITmfDataRequest.ExecutionType.FOREGROUND){

                public void handleData(TmfEvent event) {
                    super.handleData((TmfData)event);
                }

                public void handleCompleted() {
                    final int index = (int)TmfEventsTable.this.fTrace.getRank(signal.getCurrentTime());
                    TmfEventsTable.this.fTable.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TmfEventsTable.this.fTable.isDisposed()) {
                                return;
                            }
                            (this).TmfEventsTable.this.fTable.setSelection(index);
                            if (index > 0 && index == (this).TmfEventsTable.this.fTable.getTopIndex()) {
                                (this).TmfEventsTable.this.fTable.setTopIndex(index - 1);
                            }
                        }
                    });
                    super.handleCompleted();
                }
            };
            TmfExperiment experiment = TmfExperiment.getCurrentExperiment();
            if (experiment != null) {
                experiment.sendRequest((ITmfDataRequest)subRequest);
            }
        }
    }
}

