/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.parsers.ParserProviderManager;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.project.model.ITmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfExperimentNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectContentProvider;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectLabelProvider;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectRoot;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfTraceNode;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ResourceTransfer;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.project";
    private TreeViewer fViewer;
    private TmfProjectRoot fProjectRoot;
    private IWorkspace fWorkspace;
    private IResourceChangeListener fResourceChangeListener;
    private IEclipsePreferences.IPreferenceChangeListener fPreferenceChangeListener;
    private Runnable fViewRefresher = new Runnable(){

        @Override
        public void run() {
            if (ProjectView.this.fViewer != null && !ProjectView.this.fViewer.getTree().isDisposed()) {
                Object[] elements = ProjectView.this.fViewer.getExpandedElements();
                ProjectView.this.fViewer.refresh();
                ProjectView.this.fViewer.setExpandedElements(elements);
            }
        }
    };

    public static IFolder getActiveProjectTracesFolder() {
        IProject[] projects;
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.linuxtools.tmf.ui");
        String activeProjectName = node.get("ACTIVE_PROJECT", "");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && project.getName().equals(activeProjectName)) {
                return project.getFolder("Traces");
            }
            ++n2;
        }
        return null;
    }

    public static IFile createLink(URI uri) throws CoreException {
        IFolder folder = ProjectView.getActiveProjectTracesFolder();
        if (folder == null || !folder.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", "No active project set"));
        }
        String path = uri.getPath();
        IFile file = folder.getFile(path.substring(path.lastIndexOf(47)));
        if (!file.exists()) {
            file.createLink(uri, 0, null);
        }
        return file;
    }

    public TmfProjectRoot getRoot() {
        return this.fProjectRoot;
    }

    public ProjectView() {
        super("Projects");
        this.fWorkspace = ResourcesPlugin.getWorkspace();
        try {
            this.fWorkspace.getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.fProjectRoot = new TmfProjectRoot(this);
    }

    public void refresh() {
        Tree tree = this.fViewer.getTree();
        if (tree != null && !tree.isDisposed()) {
            tree.getDisplay().asyncExec(this.fViewRefresher);
        }
    }

    public void setSelection(ITmfProjectTreeNode node) {
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.fResourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 1) {
                    ProjectView.this.fProjectRoot.refreshChildren();
                    ProjectView.this.refresh();
                }
            }
        };
        this.fWorkspace.addResourceChangeListener(this.fResourceChangeListener);
        this.fPreferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                ProjectView.this.refresh();
            }
        };
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.linuxtools.tmf.ui");
        node.addPreferenceChangeListener(this.fPreferenceChangeListener);
    }

    @Override
    public void dispose() {
        this.fWorkspace.removeResourceChangeListener(this.fResourceChangeListener);
    }

    @Override
    public void createPartControl(Composite parent) {
        this.fViewer = new TreeViewer(parent, 4);
        this.fViewer.setContentProvider((IContentProvider)new TmfProjectContentProvider());
        this.fViewer.setSorter(new ViewerSorter());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new TmfProjectLabelProvider());
        this.fViewer.setInput((Object)this.fProjectRoot);
        int ops = 7;
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        this.fViewer.addDropSupport(ops, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.fViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (!(target instanceof ITmfProjectTreeNode)) {
                    return false;
                }
                this.overrideOperation(4);
                return true;
            }

            public boolean performDrop(Object data) {
                block11: {
                    IFolder targetFolder;
                    block10: {
                        Object target = this.getCurrentTarget();
                        ITmfProjectTreeNode node = (TmfProjectTreeNode)target;
                        while (node != null && !(node instanceof TmfProjectNode)) {
                            node = node.getParent();
                        }
                        targetFolder = ((TmfProjectNode)node).getTracesFolder().getFolder();
                        if (!(data instanceof String[])) break block10;
                        System.out.println("Drop:" + ((String[])data)[0]);
                        System.out.println("Folder:" + targetFolder);
                        String[] stringArray = (String[])data;
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String path = stringArray[n2];
                            File sourceFile = new File(path);
                            if (sourceFile.isFile()) {
                                IFile file = targetFolder.getFile(path.substring(path.lastIndexOf(File.separator)));
                                try {
                                    file.createLink(sourceFile.toURI(), 0, null);
                                    ITmfTrace trace = ParserProviderManager.getTrace((IResource)file);
                                    if (trace != null) {
                                        trace.dispose();
                                    }
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                            ++n2;
                        }
                        break block11;
                    }
                    if (!(data instanceof IResource[])) break block11;
                    System.out.println("Drop:" + ((IResource[])data)[0].getName());
                    System.out.println("Folder:" + targetFolder);
                    IResource[] iResourceArray = (IResource[])data;
                    int n = iResourceArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IResource resource = iResourceArray[n3];
                        if (resource instanceof IFile) {
                            IFile file = targetFolder.getFile(resource.getName());
                            try {
                                file.createLink(resource.getLocation(), 0, null);
                                String parser = resource.getPersistentProperty(ParserProviderManager.PARSER_PROPERTY);
                                file.setPersistentProperty(ParserProviderManager.PARSER_PROPERTY, parser);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                        ++n3;
                    }
                }
                return true;
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        this.hookMouse();
        this.createContextMenu();
    }

    public String toString() {
        return "[ProjectView]";
    }

    private void hookMouse() {
        this.fViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                TreeItem treeItem = ProjectView.this.fViewer.getTree().getItem(new Point(event.x, event.y));
                if (treeItem == null) {
                    return;
                }
                Object element = treeItem.getData();
                if (element instanceof TmfExperimentNode) {
                    TmfExperimentNode experiment = (TmfExperimentNode)element;
                    ProjectView.this.selectExperiment(experiment);
                } else if (element instanceof TmfProjectNode) {
                    TmfProjectNode project = (TmfProjectNode)element;
                    if (project.isOpen() && project.isTmfProject()) {
                        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.linuxtools.tmf.ui");
                        node.put("ACTIVE_PROJECT", ((TmfProjectNode)element).getName());
                        try {
                            node.flush();
                        }
                        catch (BackingStoreException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (element instanceof TmfTraceNode) {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                    IHandlerService handlerService = (IHandlerService)win.getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand("org.eclipse.linuxtools.tmf.ui.command.project.trace.open", null);
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                    catch (NotDefinedException e) {
                        e.printStackTrace();
                    }
                    catch (NotEnabledException notEnabledException) {
                    }
                    catch (NotHandledException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void selectExperiment(TmfExperimentNode experiment) {
        String expId = experiment.getName();
        try {
            TmfTraceNode[] traceEntries = experiment.getTraces();
            int nbTraces = traceEntries.length;
            ArrayList<ITmfTrace> traces = new ArrayList<ITmfTrace>();
            int cacheSize = Integer.MAX_VALUE;
            int i = 0;
            while (i < nbTraces) {
                IResource resource = traceEntries[i].getResource();
                resource = experiment.getProject().getTracesFolder().getTraceForLocation(resource.getLocation()).getResource();
                ITmfTrace expTrace = ParserProviderManager.getTrace(resource);
                if (expTrace != null) {
                    traces.add(expTrace);
                    cacheSize = Math.min(cacheSize, expTrace.getCacheSize());
                    try {
                        ITmfTrace trace = ParserProviderManager.getTrace(resource);
                        TmfEditorInput editorInput = new TmfEditorInput(resource, trace);
                        IWorkbench wb = PlatformUI.getWorkbench();
                        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
                        String editorId = ParserProviderManager.getEditorId(resource);
                        IEditorPart editor = activePage.findEditor((IEditorInput)editorInput);
                        if (editor != null && editor instanceof IReusableEditor) {
                            activePage.reuseEditor((IReusableEditor)editor, (IEditorInput)editorInput);
                            activePage.activate((IWorkbenchPart)editor);
                        } else {
                            editor = activePage.openEditor((IEditorInput)editorInput, editorId);
                        }
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            TmfExperiment selectedExperiment = new TmfExperiment(TmfEvent.class, expId, traces.toArray(new ITmfTrace[0]), cacheSize);
            this.broadcast((TmfSignal)new TmfExperimentSelectedSignal((Object)this, selectedExperiment));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        Menu menu = menuManager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
    }
}

