/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.tmf.ui.views.project.dialogs.AddTraceWizardPage;
import org.eclipse.linuxtools.tmf.ui.views.project.dialogs.Messages;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfExperimentNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfTraceNode;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class AddTraceWizard
extends Wizard
implements IImportWizard {
    private TmfProjectNode fProject;
    private TmfExperimentNode fExperiment;
    private AddTraceWizardPage fMainPage;

    public AddTraceWizard(TmfProjectNode project, TmfExperimentNode experiment) {
        this.fProject = project;
        this.fExperiment = experiment;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.AddTraceWizard_WindowTitle);
    }

    public void addPages() {
        super.addPages();
        this.fMainPage = new AddTraceWizardPage(this.fProject, "Some string");
        this.addPage((IWizardPage)this.fMainPage);
    }

    public boolean performFinish() {
        TmfTraceNode[] traces;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFolder experimentFolder = this.fExperiment.getFolder();
        TmfTraceNode[] tmfTraceNodeArray = traces = this.fMainPage.getSelection();
        int n = traces.length;
        int n2 = 0;
        while (n2 < n) {
            TmfTraceNode trace = tmfTraceNodeArray[n2];
            try {
                IResource resource = trace.getResource();
                IPath location = resource.getLocation();
                if (resource instanceof IFolder) {
                    IFolder folder = experimentFolder.getFolder(trace.getName());
                    if (workspace.validateLinkLocation((IResource)folder, location).isOK()) {
                        folder.createLink(location, 256, null);
                    } else {
                        System.out.println("Invalid Trace Location");
                    }
                } else {
                    IFile file = experimentFolder.getFile(trace.getName());
                    if (workspace.validateLinkLocation((IResource)file, location).isOK()) {
                        file.createLink(location, 256, null);
                    } else {
                        System.out.println("Invalid Trace Location");
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return true;
    }
}

