/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.parsers.ParserProviderManager;
import org.eclipse.linuxtools.tmf.ui.views.project.ProjectView;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfExperimentNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfTraceNode;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenTraceHandler
extends AbstractHandler {
    private TmfTraceNode fTrace = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        if (!(page.getActivePart() instanceof ProjectView)) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.tmf.ui.views.project");
        if (selection instanceof StructuredSelection) {
            Object element = ((StructuredSelection)selection).getFirstElement();
            TmfTraceNode tmfTraceNode = this.fTrace = element instanceof TmfTraceNode ? (TmfTraceNode)element : null;
        }
        return this.fTrace != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITmfTrace trace;
        IResource resource = this.fTrace.getResource();
        if (this.fTrace.getParent() instanceof TmfExperimentNode) {
            resource = this.fTrace.getProject().getTracesFolder().getTraceForLocation(resource.getLocation()).getResource();
        }
        if ((trace = ParserProviderManager.getTrace(resource)) == null) {
            return null;
        }
        try {
            TmfEditorInput editorInput = new TmfEditorInput(resource, trace);
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
            String editorId = ParserProviderManager.getEditorId(resource);
            IEditorPart editor = activePage.findEditor((IEditorInput)editorInput);
            if (editor != null && editor instanceof IReusableEditor) {
                activePage.reuseEditor((IReusableEditor)editor, (IEditorInput)editorInput);
                activePage.activate((IWorkbenchPart)editor);
            } else {
                editor = activePage.openEditor((IEditorInput)editorInput, editorId);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return null;
    }
}

