/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.signal.TmfTraceParserUpdatedSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.parsers.ParserProviderManager;
import org.eclipse.linuxtools.tmf.ui.views.project.ProjectView;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfExperimentNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfTraceNode;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SelectParserHandler
extends AbstractHandler {
    private TmfTraceNode fTrace = null;
    private ProjectView fProjectView = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        if (!(page.getActivePart() instanceof ProjectView)) {
            return false;
        }
        this.fProjectView = (ProjectView)page.getActivePart();
        ISelection selection = page.getSelection("org.eclipse.linuxtools.tmf.ui.views.project");
        if (selection instanceof StructuredSelection) {
            Object element = ((StructuredSelection)selection).getFirstElement();
            TmfTraceNode tmfTraceNode = this.fTrace = element instanceof TmfTraceNode ? (TmfTraceNode)element : null;
        }
        return this.fTrace != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource resource = this.fTrace.getResource();
        if (this.fTrace.getParent() instanceof TmfExperimentNode) {
            resource = this.fTrace.getProject().getTracesFolder().getTraceForLocation(resource.getLocation()).getResource();
        }
        String parser = event.getParameter("org.eclipse.linuxtools.tmf.ui.commandparameter.project.trace.selectparser.parser");
        try {
            resource.setPersistentProperty(ParserProviderManager.PARSER_PROPERTY, parser);
            this.fProjectView.broadcast((TmfSignal)new TmfTraceParserUpdatedSignal((Object)this.fProjectView, resource));
            this.fTrace.getProject().refresh();
            TmfExperiment currentExperiment = TmfExperiment.getCurrentExperiment();
            if (currentExperiment != null) {
                int i = 0;
                while (i < currentExperiment.getTraces().length) {
                    ITmfTrace newTrace;
                    ITmfTrace trace = currentExperiment.getTraces()[i];
                    if (resource.getLocation().toOSString().equals(trace.getPath()) && (newTrace = ParserProviderManager.getTrace(resource)) != null) {
                        currentExperiment.getTraces()[i] = newTrace;
                        this.fProjectView.broadcast((TmfSignal)new TmfExperimentSelectedSignal(new Object(), currentExperiment));
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

