/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.model;

import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.linuxtools.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.ui.parsers.ParserProviderManager;
import org.eclipse.linuxtools.tmf.ui.views.project.model.ITmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfExperimentFolderNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfExperimentNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfTraceFolderNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfTraceNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class TmfProjectLabelProvider
implements ILabelProvider {
    private final String fTraceIconFile = "icons/events_view.gif";
    private final Image fOpenedProjectIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    private final Image fClosedProjectIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
    private final Image fFolderIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private final Image fTraceIcon = this.loadIcon("icons/events_view.gif");
    private final Image fUnknownTraceIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
    private final Image fExperimentIcon = this.fFolderIcon;

    private Image loadIcon(String url) {
        TmfUiPlugin plugin = TmfUiPlugin.getDefault();
        Image icon = plugin.getImageRegistry().get(url);
        if (icon == null) {
            URL imageURL = plugin.getBundle().getEntry(url);
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)imageURL);
            icon = descriptor.createImage();
            plugin.getImageRegistry().put(url, icon);
        }
        return icon;
    }

    public Image getImage(Object element) {
        if (element instanceof TmfProjectNode) {
            TmfProjectNode project = (TmfProjectNode)element;
            if (project.isOpen()) {
                IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.linuxtools.tmf.ui");
                if (node.get("ACTIVE_PROJECT", "").equals(project.getName())) {
                    return this.fTraceIcon;
                }
                return this.fOpenedProjectIcon;
            }
            return this.fClosedProjectIcon;
        }
        if (element instanceof TmfTraceFolderNode) {
            return this.fFolderIcon;
        }
        if (element instanceof TmfTraceNode) {
            try {
                TmfTraceNode trace = (TmfTraceNode)element;
                IResource resource = trace.getResource();
                if (trace.getParent() instanceof TmfExperimentNode) {
                    TmfExperimentNode experiment = (TmfExperimentNode)trace.getParent();
                    TmfTraceFolderNode traceFolder = experiment.getProject().getTracesFolder();
                    resource = traceFolder.getFolder().findMember(resource.getName());
                }
                if (resource != null && resource.getPersistentProperty(ParserProviderManager.PARSER_PROPERTY) != null) {
                    return this.fTraceIcon;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return this.fUnknownTraceIcon;
        }
        if (element instanceof TmfExperimentFolderNode) {
            return this.fFolderIcon;
        }
        if (element instanceof TmfExperimentNode) {
            return this.fExperimentIcon;
        }
        return null;
    }

    public String getText(Object element) {
        ITmfProjectTreeNode node = (ITmfProjectTreeNode)element;
        String label = node.getName();
        if (node instanceof TmfTraceFolderNode || node instanceof TmfExperimentFolderNode || node instanceof TmfExperimentNode) {
            label = String.valueOf(label) + " [" + node.getChildren().size() + "]";
        }
        return label;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

