/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.launch;

import java.net.URI;
import java.sql.Date;
import java.text.DateFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.linuxtools.internal.perf.PerfCore;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class PerfOpenData
extends ProfileLaunchShortcut
implements IEditorLauncher {
    public void open(IPath file) {
        String projectName = null;
        IFile location = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file);
        if (location == null) {
            Object element;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            ISelection selection = page.getSelection();
            if (selection instanceof ITreeSelection && (element = ((ITreeSelection)selection).getFirstElement()) instanceof IFile) {
                IFile eFile = (IFile)element;
                IProject project = eFile.getProject();
                projectName = project.getName();
                URI fileURI = ((IFile)element).getLocationURI();
                ILaunchConfiguration config = this.createDefaultConfiguration(projectName);
                PerfCore.report(config, null, null, null, fileURI.getPath(), null);
                String timestamp = DateFormat.getInstance().format(new Date(eFile.getLocalTimeStamp()));
                PerfCore.refreshView(String.valueOf(fileURI.toString()) + " (" + timestamp + ")");
            }
        } else {
            projectName = location.getProject().getName();
            ILaunchConfiguration config = this.createDefaultConfiguration(projectName);
            PerfCore.report(config, null, null, null, file.toOSString(), null);
            String timestamp = DateFormat.getInstance().format(new Date(location.getLocalTimeStamp()));
            PerfCore.refreshView(String.valueOf(file.toOSString()) + " (" + timestamp + ")");
        }
    }

    protected ILaunchConfigurationType getLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.linuxtools.perf.launch.profile");
    }

    protected void setDefaultProfileAttributes(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
    }

    private ILaunchConfiguration createDefaultConfiguration(String projectName) {
        ILaunchConfigurationWorkingCopy config = null;
        try {
            ILaunchConfigurationType configType = this.getLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(projectName));
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", projectName);
            config = wc;
        }
        catch (CoreException e) {
            PerfCore.logException((Exception)((Object)e));
        }
        return config;
    }
}

