/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.cdt.libhover.LibhoverPlugin;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHover;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHoverLibrary;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.ParseDevHelp;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.LibHoverMessages;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DevHelpPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.cdt.libhover.devhelp";
    private static final String REGENERATE_MSG = "Libhover.Devhelp.Regenerate.msg";
    private static DevHelpPlugin plugin;
    private static Job k;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        k = new DevhelpStartupJob(LibHoverMessages.getString(REGENERATE_MSG));
        k.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        k.cancel();
        plugin = null;
        super.stop(context);
    }

    public static DevHelpPlugin getDefault() {
        return plugin;
    }

    public void earlyStartup() {
    }

    private static class DevhelpStartupJob
    extends Job {
        private IProgressMonitor runMonitor;

        public DevhelpStartupJob(String name) {
            super(name);
        }

        protected void canceling() {
            if (this.runMonitor != null) {
                this.runMonitor.setCanceled(true);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            long ltime2;
            this.runMonitor = monitor;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IPreferenceStore ps = DevHelpPlugin.getDefault().getPreferenceStore();
            String devhelpDir = ps.getString("org.eclipse.linuxtools.cdt.libhover.devhelp.directory");
            Path devhelpPath = new Path(devhelpDir);
            File devhelp = devhelpPath.toFile();
            if (!devhelp.exists()) {
                monitor.done();
                return Status.OK_STATUS;
            }
            long ltime = devhelp.lastModified();
            IPath libhoverPath = LibhoverPlugin.getDefault().getStateLocation().append("C").append("devhelp.libhover");
            File libhoverDir = new File(libhoverPath.toOSString());
            if (libhoverDir.exists() && ltime < (ltime2 = libhoverDir.lastModified())) {
                monitor.done();
                return Status.OK_STATUS;
            }
            ParseDevHelp.DevHelpParser p = new ParseDevHelp.DevHelpParser(ps.getString("org.eclipse.linuxtools.cdt.libhover.devhelp.directory"));
            LibHoverInfo hover = p.parse(monitor);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Collection libs = LibHover.getLibraries();
            for (LibHoverLibrary l : libs) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (!l.getName().equals("devhelp")) continue;
                l.setHoverinfo(hover);
                break;
            }
            try {
                block23: {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    IPath location = LibhoverPlugin.getDefault().getStateLocation().append("C");
                    File ldir = new File(location.toOSString());
                    ldir.mkdir();
                    location = location.append("devhelp.libhover");
                    Throwable throwable = null;
                    Object var16_19 = null;
                    try {
                        FileOutputStream f = new FileOutputStream(location.toOSString());
                        try {
                            try (ObjectOutputStream out = new ObjectOutputStream(f);){
                                out.writeObject(hover);
                            }
                            if (f == null) break block23;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (f == null) throw throwable;
                            f.close();
                            throw throwable;
                        }
                        f.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
            catch (NullPointerException e) {
                monitor.done();
                return Status.CANCEL_STATUS;
            }
            catch (IOException e) {
                monitor.done();
                return new Status(4, DevHelpPlugin.PLUGIN_ID, e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

