/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.utils;

import java.io.File;
import java.io.IOException;
import java.util.WeakHashMap;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.binutils.utils.STBinutilsFactoryManager;
import org.eclipse.linuxtools.binutils.utils.STNMSymbolsHandler;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;

public class STGcovProgramChecker
implements STNMSymbolsHandler {
    private boolean gcovFound = false;
    private long timestamp;
    private static final WeakHashMap<File, STGcovProgramChecker> map = new WeakHashMap();

    private STGcovProgramChecker(long timestamp) {
        this.timestamp = timestamp;
    }

    private static STGcovProgramChecker getProgramChecker(IBinaryParser.IBinaryObject object, IProject project) throws IOException {
        File program = object.getPath().toFile();
        STGcovProgramChecker pg = map.get(program);
        if (pg == null) {
            pg = new STGcovProgramChecker(program.lastModified());
            STBinutilsFactoryManager.getNM((String)object.getCPU(), (String)object.getPath().toOSString(), (STNMSymbolsHandler)pg, (IProject)project);
            map.put(program, pg);
        } else {
            long fileTime = program.lastModified();
            if (fileTime > pg.timestamp) {
                pg.timestamp = fileTime;
                pg.gcovFound = false;
                STBinutilsFactoryManager.getNM((String)object.getCPU(), (String)object.getPath().toOSString(), (STNMSymbolsHandler)pg, (IProject)project);
            }
        }
        return pg;
    }

    public static boolean isGCovCompatible(String s, IProject project) throws IOException {
        IBinaryParser.IBinaryObject object = STSymbolManager.sharedInstance.getBinaryObject((IPath)new Path(s));
        if (object == null) {
            return false;
        }
        return STGcovProgramChecker.isGCovCompatible(object, project);
    }

    public static boolean isGCovCompatible(IBinaryParser.IBinaryObject object, IProject project) throws IOException {
        STGcovProgramChecker pg = STGcovProgramChecker.getProgramChecker(object, project);
        return pg.gcovFound;
    }

    public void foundBssSymbol(String symbol, String address) {
    }

    public void foundDataSymbol(String symbol, String address) {
    }

    public void foundTextSymbol(String symbol, String address) {
        if ("gcov_read_words".equals(symbol) || "_gcov_read_words".equals(symbol)) {
            this.gcovFound = true;
        }
    }

    public void foundUndefSymbol(String symbol) {
    }
}

