/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.man.parser;

import com.jcraft.jsch.JSchException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.man.Activator;
import org.eclipse.linuxtools.internal.man.parser.Messages;
import org.eclipse.linuxtools.tools.launch.core.factory.LinuxtoolsProcessFactory;

public class ManParser {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StringBuilder getRawManPage(String manPage) {
        ProcessBuilder builder = new ProcessBuilder(ManParser.getManExecutable(), manPage);
        builder.redirectErrorStream(true);
        StringBuilder sb = new StringBuilder();
        try {
            Process process = builder.start();
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") != 0) {
                process.waitFor();
            }
            String line = null;
            Throwable throwable = null;
            Object var7_10 = null;
            try {
                InputStream manContent = process.getInputStream();
                try {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(manContent));){
                        while ((line = reader.readLine()) != null) {
                            sb.append(String.valueOf(line) + "\n");
                        }
                    }
                    if (manContent == null) return sb;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (manContent == null) throw throwable;
                    manContent.close();
                    throw throwable;
                }
                manContent.close();
                return sb;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | InterruptedException e1) {
            Status status = new Status(4, e1.getMessage(), Activator.getDefault().getPluginId());
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return sb;
    }

    public StringBuilder getRemoteRawManPage(String manPage, String user, String host, String password) {
        final StringBuilder sb = new StringBuilder();
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                sb.append((char)b);
            }
        };
        try {
            LinuxtoolsProcessFactory.execRemoteAndWait((String[])new String[]{ManParser.getManExecutable(), manPage}, (OutputStream)out, (OutputStream)out, (String)user, (String)host, (String)password);
        }
        catch (JSchException e) {
            sb.setLength(0);
            sb.append(Messages.ManParser_RemoteAccessError);
        }
        return sb;
    }

    private static String getManExecutable() {
        return Activator.getDefault().getPreferenceStore().getString("pathPreference");
    }
}

