/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.launch.configuration;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchMessages;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchPlugin;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.LaunchOptions;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class OprofileSetupTab
extends AbstractLaunchConfigurationTab {
    protected Text kernelImageFileText;
    protected CCombo controlCombo;
    protected Button checkSeparateLibrary;
    protected Button checkSeparateKernel;
    protected LaunchOptions options = null;
    protected Spinner executionsSpinner;
    private IRemoteFileProxy proxy;
    protected Label kernelLabel;

    public String getName() {
        return OprofileLaunchMessages.getString("tab.global.name");
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.options.isValid();
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.options.saveConfiguration(config);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.options.loadConfiguration(config);
        try {
            if (config.getType().getIdentifier().equals("org.eclipse.linuxtools.oprofile.launch.oprofile.manual")) {
                this.controlCombo.setEnabled(false);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.controlCombo.setText(this.options.getOprofileComboText());
        if (this.controlCombo.getText().equals("operf")) {
            this.checkSeparateLibrary.setEnabled(false);
            this.checkSeparateKernel.setEnabled(false);
            this.kernelImageFileText.setEnabled(false);
            this.kernelLabel.setEnabled(false);
        } else {
            this.checkSeparateLibrary.setEnabled(true);
            this.checkSeparateKernel.setEnabled(true);
            this.kernelImageFileText.setEnabled(true);
            this.kernelLabel.setEnabled(true);
        }
        this.kernelImageFileText.setText(this.options.getKernelImageFile());
        this.executionsSpinner.setSelection(this.options.getExecutionsNumber());
        int separate = this.options.getSeparateSamples();
        if (separate == 0) {
            this.checkSeparateLibrary.setSelection(false);
            this.checkSeparateKernel.setSelection(false);
        } else {
            if ((separate & 1) != 0) {
                this.checkSeparateLibrary.setSelection(true);
            }
            if ((separate & 2) != 0) {
                this.checkSeparateKernel.setSelection(true);
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.options = new LaunchOptions();
        this.options.saveConfiguration(config);
    }

    public Image getImage() {
        return OprofileLaunchPlugin.getImageDescriptor("icons/global_tab.gif").createImage();
    }

    public void createControl(Composite parent) {
        this.options = new LaunchOptions();
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(top, 1);
        Composite p = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        p.setLayout((Layout)layout);
        GridData data = new GridData(768);
        p.setLayoutData((Object)data);
        Label l2 = new Label(p, 0);
        l2.setText(OprofileLaunchMessages.getString("tab.global.select"));
        data = new GridData();
        data.horizontalSpan = 2;
        l2.setLayoutData((Object)data);
        this.controlCombo = new CCombo(p, 2060);
        ArrayList<String> tools = new ArrayList<String>(Arrays.asList("operf"));
        try {
            Process proc = RuntimeProcessFactory.getFactory().exec(new String[]{"which", "opcontrol"}, null);
            if (proc.waitFor() == 0) {
                tools.add("opcontrol");
            }
        }
        catch (Exception proc) {
            // empty catch block
        }
        this.controlCombo.setItems(tools.toArray(new String[0]));
        this.controlCombo.select(0);
        this.controlCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent mev) {
                Oprofile.OprofileProject.setProfilingBinary((String)OprofileSetupTab.this.controlCombo.getText());
                OprofileSetupTab.this.options.setOprofileComboText(OprofileSetupTab.this.controlCombo.getText());
                if (OprofileSetupTab.this.controlCombo.getText().equals("operf")) {
                    OprofileSetupTab.this.checkSeparateLibrary.setEnabled(false);
                    OprofileSetupTab.this.checkSeparateKernel.setEnabled(false);
                    OprofileSetupTab.this.kernelImageFileText.setEnabled(false);
                    OprofileSetupTab.this.kernelLabel.setEnabled(false);
                } else {
                    OprofileSetupTab.this.checkSeparateLibrary.setEnabled(true);
                    OprofileSetupTab.this.checkSeparateKernel.setEnabled(true);
                    OprofileSetupTab.this.kernelImageFileText.setEnabled(true);
                    OprofileSetupTab.this.kernelLabel.setEnabled(true);
                }
                OprofileSetupTab.this.updateLaunchConfigurationDialog();
            }
        });
        data = new GridData();
        data.horizontalSpan = 2;
        this.controlCombo.setLayoutData((Object)data);
        this.kernelLabel = new Label(p, 0);
        this.kernelLabel.setText(OprofileLaunchMessages.getString("tab.global.kernelImage.label.text"));
        this.kernelLabel.setEnabled(false);
        data = new GridData();
        data.horizontalSpan = 2;
        this.kernelLabel.setLayoutData((Object)data);
        this.kernelImageFileText = new Text(p, 2052);
        data = new GridData(768);
        this.kernelImageFileText.setLayoutData((Object)data);
        this.kernelImageFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent mev) {
                OprofileSetupTab.this.handleKernelImageFileTextModify(OprofileSetupTab.this.kernelImageFileText);
            }
        });
        Button button = this.createPushButton(p, OprofileLaunchMessages.getString("tab.global.kernelImage.browse.button.text"), null);
        final Shell shell = top.getShell();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sev) {
                OprofileSetupTab.this.showFileDialog(shell);
            }
        });
        this.createVerticalSpacer(top, 1);
        p = new Composite(top, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        p.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        p.setLayoutData((Object)data);
        this.checkSeparateLibrary = this.myCreateCheckButton(p, OprofileLaunchMessages.getString("tab.global.check.separateLibrary.text"));
        this.checkSeparateKernel = this.myCreateCheckButton(p, OprofileLaunchMessages.getString("tab.global.check.separateKernel.text"));
        Composite executionsComposite = new Composite(top, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        executionsComposite.setLayout((Layout)gridLayout);
        Label executionsLabel = new Label(executionsComposite, 16384);
        executionsLabel.setText(OprofileLaunchMessages.getString("tab.global.executionsNumber.label.text"));
        executionsLabel.setToolTipText(OprofileLaunchMessages.getString("tab.global.executionsNumber.label.tooltip"));
        this.executionsSpinner = new Spinner(executionsComposite, 2048);
        this.executionsSpinner.setMinimum(1);
        this.executionsSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OprofileSetupTab.this.options.setExecutionsNumber(OprofileSetupTab.this.executionsSpinner.getSelection());
                OprofileSetupTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private Button myCreateCheckButton(Composite parent, String label) {
        final Button b = new Button(parent, 32);
        b.setText(label);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OprofileSetupTab.this.handleCheckSelected(b);
            }
        });
        return b;
    }

    private void handleCheckSelected(Button button) {
        int oldSeparate;
        int newSeparate = oldSeparate = this.options.getSeparateSamples();
        if (button == this.checkSeparateLibrary) {
            newSeparate = button.getSelection() ? oldSeparate | 1 : oldSeparate & 0xFFFFFFFE;
        } else if (button == this.checkSeparateKernel) {
            newSeparate = button.getSelection() ? oldSeparate | 2 : oldSeparate & 0xFFFFFFFD;
        }
        this.options.setSeparateSamples(newSeparate);
        this.updateLaunchConfigurationDialog();
    }

    private void handleKernelImageFileTextModify(Text text) {
        String errorMessage = null;
        String filename = text.getText();
        if (filename.length() > 0) {
            try {
                this.proxy = RemoteProxyManager.getInstance().getFileProxy(this.getOprofileProject());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            IFileStore fileStore = this.proxy.getResource(filename);
            if (!fileStore.fetchInfo().exists() || fileStore.fetchInfo().isDirectory()) {
                String msg = OprofileLaunchMessages.getString("tab.global.kernelImage.kernel.nonexistent");
                Object[] args = new Object[]{filename};
                errorMessage = MessageFormat.format(msg, args);
            }
            this.options.setKernelImageFile(filename);
        } else {
            this.options.setKernelImageFile("");
        }
        this.setErrorMessage(errorMessage);
        this.updateLaunchConfigurationDialog();
    }

    private void showFileDialog(Shell shell) {
        try {
            this.proxy = RemoteProxyManager.getInstance().getFileProxy(this.getOprofileProject());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        FileDialog d = new FileDialog(shell, 4096);
        IFileStore kernel = this.proxy.getResource(this.options.getKernelImageFile());
        if (!kernel.fetchInfo().exists() && !(kernel = this.proxy.getResource("/boot")).fetchInfo().exists()) {
            kernel = this.proxy.getResource("/");
        }
        d.setFileName(kernel.toString());
        d.setText(OprofileLaunchMessages.getString("tab.global.selectKernelDialog.text"));
        String newKernel = d.open();
        if (newKernel != null) {
            kernel = this.proxy.getResource(newKernel);
            if (!kernel.fetchInfo().exists()) {
                MessageBox mb = new MessageBox(shell, 1281);
                mb.setMessage(OprofileLaunchMessages.getString("tab.global.selectKernelDialog.error.kernelDoesNotExist.text"));
                switch (mb.open()) {
                    case 1024: {
                        this.showFileDialog(shell);
                        break;
                    }
                }
            } else {
                this.kernelImageFileText.setText(newKernel);
            }
        }
    }

    protected IProject getOprofileProject() {
        return Oprofile.OprofileProject.getProject();
    }
}

