/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.remote.core.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.linux.LinuxOpcontrolProvider;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.linuxtools.tools.launch.core.properties.LinuxtoolsPathProperty;

public class RemoteLinuxOpcontrolProvider
extends LinuxOpcontrolProvider {
    private static final String OPCONTROL_EXECUTABLE = "opcontrol";
    private static final int SUDO_TIMEOUT = 5000;

    protected Process createOpcontrolProcess(String[] cmdArray, IProject project) throws OpcontrolException {
        Process p = null;
        try {
            p = RuntimeProcessFactory.getFactory().sudoExec(cmdArray, project);
        }
        catch (IOException ioe) {
            throw new OpcontrolException(OprofileCorePlugin.createErrorStatus((String)"opcontrolRun", (Exception)ioe));
        }
        return p;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasPermissions(IProject project) {
        String linuxtoolsPath = LinuxtoolsPathProperty.getInstance().getLinuxtoolsPath(project);
        try {
            String[] sudoLines;
            String opcontrolPath = null;
            opcontrolPath = linuxtoolsPath.isEmpty() ? RuntimeProcessFactory.getFactory().whichCommand(OPCONTROL_EXECUTABLE, project) : (linuxtoolsPath.endsWith("/") ? String.valueOf(linuxtoolsPath) + OPCONTROL_EXECUTABLE : String.valueOf(linuxtoolsPath) + "/opcontrol");
            if (opcontrolPath.isEmpty()) {
                return false;
            }
            final Process p = RuntimeProcessFactory.getFactory().exec("sudo -l", project);
            final StringBuffer buffer = new StringBuffer();
            if (p == null) {
                return false;
            }
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String s = null;
                        while ((s = input.readLine()) != null) {
                            buffer.append(s);
                            buffer.append('\n');
                        }
                        p.waitFor();
                        p.destroy();
                    }
                    catch (IOException | InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
            t.join(5000L);
            String[] stringArray = sudoLines = buffer.toString().split("\n");
            int n = sudoLines.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    System.out.println(buffer.toString());
                    return false;
                }
                String s = stringArray[n2];
                if (s.contains(opcontrolPath) && s.contains("NOPASSWD")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }
}

