/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.perf.BaseDataManipulator;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractSaveDataHandler
extends BaseDataManipulator
implements IHandler {
    public Object execute(ExecutionEvent event) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.PerfSaveSession_title, Messages.PerfSaveSession_msg, "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.isEmpty()) {
                    return Messages.PerfSaveSession_invalid_filename_msg;
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            this.saveData(dialog.getValue());
        }
        return null;
    }

    public boolean isEnabled() {
        IPath curWorkingDirectory = this.getWorkingDir();
        return curWorkingDirectory != null && !curWorkingDirectory.isEmpty() && this.verifyData();
    }

    protected IPath getWorkingDir() {
        return PerfPlugin.getDefault().getWorkingDir();
    }

    public IPath getNewDataLocation(String filename, String extension) {
        IPath newFilename = this.getWorkingDir().append(filename);
        return newFilename.addFileExtension(extension);
    }

    public boolean canSave(IPath file) {
        IRemoteFileProxy proxy = null;
        URI fileURI = null;
        try {
            fileURI = new URI(file.toPortableString());
            proxy = RemoteProxyManager.getInstance().getFileProxy(fileURI);
        }
        catch (URISyntaxException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgProxyError, (String)Messages.MsgProxyError);
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgProxyError, (String)Messages.MsgProxyError);
        }
        IFileStore fileStore = proxy.getResource(fileURI.getPath());
        if (fileStore.fetchInfo().exists()) {
            String msg = MessageFormat.format(Messages.PerfSaveSession_file_exists_msg, fileStore.getName());
            return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PerfSaveSession_file_exists_title, (String)msg);
        }
        return true;
    }

    public void openErroDialog(final String title, String pattern, String arg) {
        final String errorMsg = MessageFormat.format(pattern, arg);
        if (Display.getCurrent() != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)errorMsg);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)errorMsg);
                }
            });
        }
    }

    public abstract IPath saveData(String var1);

    public abstract boolean verifyData();

    public boolean isHandled() {
        return this.isEnabled();
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }
}

