/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.tests.mock;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.eclipse.lsp4e.tests.mock.MockTextDocumentService;
import org.eclipse.lsp4e.tests.mock.MockWorkspaceService;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkOptions;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.WorkspaceService;

public final class MockLanguageServerMultiRootFolders
implements LanguageServer {
    public static MockLanguageServerMultiRootFolders INSTANCE = new MockLanguageServerMultiRootFolders();
    private MockTextDocumentService textDocumentService = new MockTextDocumentService(this::buildMaybeDelayedFuture);
    private MockWorkspaceService workspaceService = new MockWorkspaceService(this::buildMaybeDelayedFuture);
    private InitializeResult initializeResult = new InitializeResult();
    private long delay = 0L;
    private boolean started;

    public static void reset() {
        INSTANCE = new MockLanguageServerMultiRootFolders();
    }

    private MockLanguageServerMultiRootFolders() {
        this.resetInitializeResult();
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        Launcher l = LSPLauncher.createServerLauncher((LanguageServer)INSTANCE, (InputStream)System.in, (OutputStream)System.out);
        Future f = l.startListening();
        INSTANCE.addRemoteProxy((LanguageClient)l.getRemoteProxy());
        f.get();
    }

    public void addRemoteProxy(LanguageClient remoteProxy) {
        this.textDocumentService.addRemoteProxy(remoteProxy);
        this.started = true;
    }

    private void resetInitializeResult() {
        ServerCapabilities capabilities = new ServerCapabilities();
        capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
        CompletionOptions completionProvider = new CompletionOptions(Boolean.valueOf(false), null);
        capabilities.setCompletionProvider(completionProvider);
        capabilities.setHoverProvider(Boolean.valueOf(true));
        capabilities.setDefinitionProvider(Boolean.valueOf(true));
        capabilities.setReferencesProvider(Boolean.valueOf(true));
        capabilities.setDocumentFormattingProvider(Boolean.valueOf(true));
        capabilities.setCodeActionProvider(Boolean.TRUE);
        capabilities.setCodeLensProvider(new CodeLensOptions(true));
        capabilities.setDocumentLinkProvider(new DocumentLinkOptions());
        capabilities.setSignatureHelpProvider(new SignatureHelpOptions());
        capabilities.setDocumentHighlightProvider(Boolean.TRUE);
        WorkspaceServerCapabilities workspace = new WorkspaceServerCapabilities();
        WorkspaceFoldersOptions workspaceFolders = new WorkspaceFoldersOptions();
        workspaceFolders.setSupported(Boolean.TRUE);
        workspace.setWorkspaceFolders(workspaceFolders);
        capabilities.setWorkspace(workspace);
        this.initializeResult.setCapabilities(capabilities);
    }

    <U> CompletableFuture<U> buildMaybeDelayedFuture(final U value) {
        if (this.delay > 0L) {
            return CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }).thenApply(new Function<Void, U>(){

                @Override
                public U apply(Void v) {
                    return value;
                }
            });
        }
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        return this.buildMaybeDelayedFuture(this.initializeResult);
    }

    public MockTextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    public void setCompletionList(CompletionList completionList) {
        this.textDocumentService.setMockCompletionList(completionList);
    }

    public void setHover(Hover hover) {
        this.textDocumentService.setMockHover(hover);
    }

    public void setCodeLens(List<CodeLens> codeLens) {
        this.textDocumentService.setMockCodeLenses(codeLens);
    }

    public void setDefinition(List<? extends Location> definitionLocations) {
        this.textDocumentService.setMockDefinitionLocations(definitionLocations);
    }

    public void setDidOpenCallback(CompletableFuture<DidOpenTextDocumentParams> didOpenExpectation) {
        this.textDocumentService.setDidOpenCallback(didOpenExpectation);
    }

    public void setDidChangeCallback(CompletableFuture<DidChangeTextDocumentParams> didChangeExpectation) {
        this.textDocumentService.setDidChangeCallback(didChangeExpectation);
    }

    public void setDidSaveCallback(CompletableFuture<DidSaveTextDocumentParams> didSaveExpectation) {
        this.textDocumentService.setDidSaveCallback(didSaveExpectation);
    }

    public void setDidCloseCallback(CompletableFuture<DidCloseTextDocumentParams> didCloseExpectation) {
        this.textDocumentService.setDidCloseCallback(didCloseExpectation);
    }

    public void setFormattingTextEdits(List<? extends TextEdit> formattingTextEdits) {
        this.textDocumentService.setMockFormattingTextEdits(formattingTextEdits);
    }

    public void setDocumentHighlights(List<? extends DocumentHighlight> documentHighlights) {
        this.textDocumentService.setDocumentHighlights(documentHighlights);
    }

    public void setCompletionTriggerChars(Set<String> chars) {
        if (chars != null) {
            this.initializeResult.getCapabilities().getCompletionProvider().setTriggerCharacters(new ArrayList<String>(chars));
        }
    }

    public void setContextInformationTriggerChars(Set<String> chars) {
        if (chars != null) {
            this.initializeResult.getCapabilities().getSignatureHelpProvider().setTriggerCharacters(new ArrayList<String>(chars));
        }
    }

    public InitializeResult getInitializeResult() {
        return this.initializeResult;
    }

    public CompletableFuture<Object> shutdown() {
        this.started = false;
        this.delay = 0L;
        this.resetInitializeResult();
        this.textDocumentService.reset();
        return CompletableFuture.completedFuture(Collections.emptySet());
    }

    public void exit() {
    }

    public void setTimeToProceedQueries(int i) {
        this.delay = i;
    }

    public void setDiagnostics(List<Diagnostic> diagnostics) {
        this.textDocumentService.setDiagnostics(diagnostics);
    }

    public void setCodeActions(List<Either<Command, CodeAction>> codeActions) {
        this.textDocumentService.setCodeActions(codeActions);
    }

    public void setSignatureHelp(SignatureHelp signatureHelp) {
        this.textDocumentService.setSignatureHelp(signatureHelp);
    }

    public void setDocumentLinks(List<DocumentLink> documentLinks) {
        this.textDocumentService.setMockDocumentLinks(documentLinks);
    }

    public boolean isRunning() {
        return this.started;
    }
}

