/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.lsp4e.DocumentInputStream;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.refactoring.CreateFileChange;
import org.eclipse.lsp4e.refactoring.DeleteExternalFile;
import org.eclipse.lsp4e.refactoring.LSPTextChange;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.mylyn.wikitext.markdown.MarkdownLanguage;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPEclipseUtils {
    private static final String FILE = "file:";
    private static final String FILE_SLASH = "file:/";
    private static final String HTML = "html";
    private static final String MARKDOWN = "markdown";
    private static final String MD = "md";
    private static final int MAX_BROWSER_NAME_LENGTH = 30;
    private static final MarkupParser MARKDOWN_PARSER = new MarkupParser((MarkupLanguage)new MarkdownLanguage());

    private LSPEclipseUtils() {
    }

    public static ITextEditor getActiveTextEditor() {
        MultiPageEditorPart multiPageEditorPart;
        Object page;
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof ITextEditor) {
            return (ITextEditor)editorPart;
        }
        if (editorPart instanceof MultiPageEditorPart && (page = (multiPageEditorPart = (MultiPageEditorPart)editorPart).getSelectedPage()) instanceof ITextEditor) {
            return (ITextEditor)page;
        }
        return null;
    }

    public static Position toPosition(int offset, IDocument document) throws BadLocationException {
        Position res = new Position();
        res.setLine(document.getLineOfOffset(offset));
        res.setCharacter(offset - document.getLineInformationOfOffset(offset).getOffset());
        return res;
    }

    public static int toOffset(Position position, IDocument document) throws BadLocationException {
        return document.getLineInformation(position.getLine()).getOffset() + position.getCharacter();
    }

    public static boolean isOffsetInRange(int offset, Range range, IDocument document) {
        try {
            return offset != -1 && offset >= LSPEclipseUtils.toOffset(range.getStart(), document) && offset <= LSPEclipseUtils.toOffset(range.getEnd(), document);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return false;
        }
    }

    public static CompletionParams toCompletionParams(URI fileUri, int offset, IDocument document) throws BadLocationException {
        Position start = LSPEclipseUtils.toPosition(offset, document);
        CompletionParams param = new CompletionParams();
        param.setPosition(start);
        param.setUri(fileUri.toString());
        TextDocumentIdentifier id = new TextDocumentIdentifier();
        id.setUri(fileUri.toString());
        param.setTextDocument(id);
        return param;
    }

    @Deprecated
    public static TextDocumentPositionParams toTextDocumentPosistionParams(URI fileUri, int offset, IDocument document) throws BadLocationException {
        Position start = LSPEclipseUtils.toPosition(offset, document);
        TextDocumentPositionParams param = new TextDocumentPositionParams();
        param.setPosition(start);
        param.setUri(fileUri.toString());
        TextDocumentIdentifier id = new TextDocumentIdentifier();
        id.setUri(fileUri.toString());
        param.setTextDocument(id);
        return param;
    }

    private static <T extends TextDocumentPositionParams> T toTextDocumentPositionParamsCommon(@NonNull T param, int offset, IDocument document) throws BadLocationException {
        URI uri = LSPEclipseUtils.toUri(document);
        Position start = LSPEclipseUtils.toPosition(offset, document);
        param.setPosition(start);
        TextDocumentIdentifier id = new TextDocumentIdentifier();
        if (uri != null) {
            param.setUri(uri.toString());
            id.setUri(uri.toString());
        }
        param.setTextDocument(id);
        return param;
    }

    public static SignatureHelpParams toSignatureHelpParams(int offset, IDocument document) throws BadLocationException {
        return LSPEclipseUtils.toTextDocumentPositionParamsCommon(new SignatureHelpParams(), offset, document);
    }

    public static TextDocumentPositionParams toTextDocumentPosistionParams(int offset, IDocument document) throws BadLocationException {
        return LSPEclipseUtils.toTextDocumentPositionParamsCommon(new TextDocumentPositionParams(), offset, document);
    }

    public static URI toUri(IDocument document) {
        IFile file = LSPEclipseUtils.getFile(document);
        if (file != null) {
            return LSPEclipseUtils.toUri((IResource)file);
        }
        IPath path = LSPEclipseUtils.toPath(document);
        if (path != null) {
            return LSPEclipseUtils.toUri(path.toFile());
        }
        return null;
    }

    public static IPath toPath(IDocument document) {
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(document);
        if (buffer != null) {
            return buffer.getLocation();
        }
        return null;
    }

    public static int toEclipseMarkerSeverity(DiagnosticSeverity lspSeverity) {
        if (lspSeverity == null) {
            return 2;
        }
        switch (lspSeverity) {
            case Error: {
                return 2;
            }
            case Warning: {
                return 1;
            }
        }
        return 0;
    }

    public static IFile getFileHandle(@Nullable String uri) {
        if (uri == null || uri.isEmpty() || !uri.startsWith(FILE)) {
            return null;
        }
        String convertedUri = uri.replace("file:///", FILE_SLASH);
        convertedUri = convertedUri.replace("file://", FILE_SLASH);
        IPath path = Path.fromOSString((String)new File(URI.create(convertedUri)).getAbsolutePath());
        IProject project = null;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject aProject = iProjectArray[n2];
            IPath location = aProject.getLocation();
            if (location != null && location.isPrefixOf(path) && (project == null || project.getLocation().segmentCount() < location.segmentCount())) {
                project = aProject;
            }
            ++n2;
        }
        if (project == null) {
            return null;
        }
        IPath projectRelativePath = path.removeFirstSegments(project.getLocation().segmentCount());
        if (projectRelativePath.isEmpty()) {
            return null;
        }
        return project.getFile(projectRelativePath);
    }

    public static @Nullable IResource findResourceFor(@Nullable String uri) {
        if (uri == null || uri.isEmpty() || !uri.startsWith(FILE)) {
            return null;
        }
        String convertedUri = uri.replace("file:///", FILE_SLASH);
        convertedUri = convertedUri.replace("file://", FILE_SLASH);
        IPath path = Path.fromOSString((String)new File(URI.create(convertedUri)).getAbsolutePath());
        IProject project = null;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject aProject = iProjectArray[n2];
            IPath location = aProject.getLocation();
            if (location != null && location.isPrefixOf(path) && (project == null || project.getLocation().segmentCount() < location.segmentCount())) {
                project = aProject;
            }
            ++n2;
        }
        if (project == null) {
            return null;
        }
        IPath projectRelativePath = path.removeFirstSegments(project.getLocation().segmentCount());
        if (projectRelativePath.isEmpty()) {
            return project;
        }
        return project.findMember(projectRelativePath);
    }

    public static void applyEdit(org.eclipse.lsp4j.TextEdit textEdit, IDocument document) throws BadLocationException {
        document.replace(LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document), LSPEclipseUtils.toOffset(textEdit.getRange().getEnd(), document) - LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document), textEdit.getNewText());
    }

    public static void applyEdits(IDocument document, List<? extends org.eclipse.lsp4j.TextEdit> edits) {
        if (document == null || edits == null || edits.isEmpty()) {
            return;
        }
        IDocumentUndoManager manager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
        if (manager != null) {
            manager.beginCompoundChange();
        }
        MultiTextEdit edit = new MultiTextEdit();
        for (org.eclipse.lsp4j.TextEdit textEdit : edits) {
            if (textEdit == null) continue;
            try {
                int offset = LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document);
                int length = LSPEclipseUtils.toOffset(textEdit.getRange().getEnd(), document) - offset;
                edit.addChild((TextEdit)new ReplaceEdit(offset, length, textEdit.getNewText()));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        try {
            RewriteSessionEditProcessor rewriteSessionEditProcessor = new RewriteSessionEditProcessor(document, (TextEdit)edit, 0);
            rewriteSessionEditProcessor.performEdits();
        }
        catch (BadLocationException | MalformedTreeException throwable) {
            LanguageServerPlugin.logError(throwable);
        }
        if (manager != null) {
            manager.endCompoundChange();
        }
    }

    public static @Nullable IDocument getDocument(@Nullable IResource resource) {
        if (resource == null) {
            return null;
        }
        IDocument document = LSPEclipseUtils.getExistingDocument(resource);
        if (document == null && resource.getType() == 1) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            try {
                bufferManager.connect(resource.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
                return document;
            }
            ITextFileBuffer buffer = bufferManager.getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
            if (buffer != null) {
                document = buffer.getDocument();
            }
        }
        return document;
    }

    public static @Nullable IDocument getExistingDocument(@Nullable IResource resource) {
        if (resource == null) {
            return null;
        }
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer buffer = bufferManager.getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
        if (buffer != null) {
            return buffer.getDocument();
        }
        return null;
    }

    private static @Nullable IDocument getDocument(URI uri) {
        if (uri == null) {
            return null;
        }
        IResource resource = LSPEclipseUtils.findResourceFor(uri.toString());
        if (resource != null) {
            return LSPEclipseUtils.getDocument(resource);
        }
        if (!new File(uri).isFile()) {
            return null;
        }
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IDocument document = null;
        IFileStore store = null;
        try {
            store = EFS.getStore((URI)uri);
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
        ITextFileBuffer buffer = bufferManager.getFileStoreTextFileBuffer(store);
        if (buffer != null) {
            document = buffer.getDocument();
        } else {
            try {
                bufferManager.connectFileStore(store, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
                return document;
            }
            buffer = bufferManager.getFileStoreTextFileBuffer(store);
            if (buffer != null) {
                document = buffer.getDocument();
            }
        }
        return document;
    }

    public static void openInEditor(Location location, IWorkbenchPage page) {
        LSPEclipseUtils.open(location.getUri(), page, location.getRange());
    }

    public static void openInEditor(LocationLink link, IWorkbenchPage page) {
        LSPEclipseUtils.open(link.getTargetUri(), page, link.getTargetSelectionRange());
    }

    public static void open(String uri, IWorkbenchPage page, Range optionalRange) {
        if (uri.startsWith(FILE)) {
            LSPEclipseUtils.openFileLocationInEditor(uri, page, optionalRange);
        } else if (uri.startsWith("http://org.eclipse.ui.intro")) {
            LSPEclipseUtils.openIntroURL(uri);
        } else if (uri.startsWith("http")) {
            LSPEclipseUtils.openHttpLocationInBrowser(uri, page);
        }
    }

    protected static void openIntroURL(String uri) {
        IIntroURL introUrl = IntroURLFactory.createIntroURL((String)uri);
        if (introUrl != null) {
            try {
                if (!introUrl.execute()) {
                    LanguageServerPlugin.logWarning("Failed to execute IntroURL: " + uri, null);
                }
            }
            catch (Exception t) {
                LanguageServerPlugin.logWarning("Error executing IntroURL: " + uri, t);
            }
        }
    }

    protected static void openHttpLocationInBrowser(String uri, IWorkbenchPage page) {
        page.getWorkbenchWindow().getShell().getDisplay().asyncExec(() -> {
            try {
                URL url = new URL(uri);
                IWorkbenchBrowserSupport browserSupport = page.getWorkbenchWindow().getWorkbench().getBrowserSupport();
                String browserName = uri;
                if (browserName.length() > 30) {
                    browserName = String.valueOf(uri.substring(0, 29)) + '\u2026';
                }
                browserSupport.createBrowser(38, "lsp4e-symbols", browserName, uri).openURL(url);
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
        });
    }

    protected static void openFileLocationInEditor(String uri, IWorkbenchPage page, Range optionalRange) {
        IEditorPart part = null;
        IDocument targetDocument = null;
        IResource targetResource = LSPEclipseUtils.findResourceFor(uri);
        try {
            if (targetResource != null && targetResource.getType() == 1) {
                part = IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)targetResource));
                targetDocument = FileBuffers.getTextFileBufferManager().getTextFileBuffer(targetResource.getFullPath(), LocationKind.IFILE).getDocument();
            } else {
                URI fileUri = URI.create(uri).normalize();
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileUri);
                IFileInfo fetchInfo = fileStore.fetchInfo();
                if (!fetchInfo.isDirectory() && fetchInfo.exists()) {
                    part = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    ITextFileBuffer fileStoreTextFileBuffer = FileBuffers.getTextFileBufferManager().getFileStoreTextFileBuffer(fileStore);
                    targetDocument = fileStoreTextFileBuffer.getDocument();
                }
            }
        }
        catch (PartInitException e) {
            LanguageServerPlugin.logError(e);
        }
        try {
            if (part != null && part.getEditorSite() != null && part.getEditorSite().getSelectionProvider() != null && optionalRange != null) {
                ISelectionProvider selectionProvider = part.getEditorSite().getSelectionProvider();
                int offset = LSPEclipseUtils.toOffset(optionalRange.getStart(), targetDocument);
                int endOffset = LSPEclipseUtils.toOffset(optionalRange.getEnd(), targetDocument);
                selectionProvider.setSelection((ISelection)new TextSelection(offset, endOffset > offset ? endOffset - offset : 0));
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    public static IDocument getDocument(ITextEditor editor) {
        try {
            Method getSourceViewerMethod = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            getSourceViewerMethod.setAccessible(true);
            ITextViewer viewer = (ITextViewer)getSourceViewerMethod.invoke((Object)editor, new Object[0]);
            return viewer.getDocument();
        }
        catch (Exception ex) {
            LanguageServerPlugin.logError(ex);
            return null;
        }
    }

    public static IDocument getDocument(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return LSPEclipseUtils.getDocument((IResource)fileEditorInput.getFile());
        }
        if (editorInput instanceof IPathEditorInput) {
            IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput;
            return LSPEclipseUtils.getDocument((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile(pathEditorInput.getPath()));
        }
        if (editorInput instanceof IURIEditorInput) {
            IURIEditorInput uriEditorInput = (IURIEditorInput)editorInput;
            IResource resource = LSPEclipseUtils.findResourceFor(uriEditorInput.getURI().toString());
            if (resource != null) {
                return LSPEclipseUtils.getDocument(resource);
            }
            return LSPEclipseUtils.getDocument(uriEditorInput.getURI());
        }
        return null;
    }

    public static void applyWorkspaceEdit(WorkspaceEdit wsEdit) {
        CompositeChange change = LSPEclipseUtils.toCompositeChange(wsEdit);
        PerformChangeOperation changeOperation = new PerformChangeOperation((Change)change);
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)changeOperation, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    public static CompositeChange toCompositeChange(WorkspaceEdit wsEdit) {
        CompositeChange change = new CompositeChange("LSP Workspace Edit");
        List documentChanges = wsEdit.getDocumentChanges();
        if (documentChanges != null) {
            documentChanges.stream().forEach(action -> {
                String encoding;
                String content;
                DeleteResourceChange removeNewFile;
                IFile oldFile;
                URI newURI;
                URI oldURI;
                block27: {
                    if (action.isLeft()) {
                        TextDocumentEdit edit = (TextDocumentEdit)action.getLeft();
                        VersionedTextDocumentIdentifier id = edit.getTextDocument();
                        URI uri = URI.create(id.getUri());
                        List textEdits = edit.getEdits();
                        change.addAll((Change[])LSPEclipseUtils.toChanges(uri, textEdits));
                        return;
                    }
                    if (!action.isRight()) return;
                    ResourceOperation resourceOperation = (ResourceOperation)action.getRight();
                    if (resourceOperation instanceof CreateFile) {
                        CreateFile createOperation = (CreateFile)resourceOperation;
                        URI targetURI = URI.create(createOperation.getUri());
                        File targetFile = new File(targetURI);
                        if (targetFile.exists() && createOperation.getOptions() != null) {
                            if (createOperation.getOptions().getIgnoreIfExists() != false) return;
                            if (createOperation.getOptions().getOverwrite() == false) return;
                            org.eclipse.lsp4j.TextEdit edit = new org.eclipse.lsp4j.TextEdit(null, "");
                            change.add((Change)new LSPTextChange("Overwrite", targetURI, edit));
                            return;
                        }
                        CreateFileChange operation = new CreateFileChange(targetURI, "", null);
                        change.add((Change)operation);
                        return;
                    }
                    if (resourceOperation instanceof DeleteFile) {
                        IResource resource = LSPEclipseUtils.findResourceFor(((DeleteFile)resourceOperation).getUri());
                        if (resource != null) {
                            DeleteResourceChange deleteChange = new DeleteResourceChange(resource.getFullPath(), true);
                            change.add((Change)deleteChange);
                            return;
                        }
                        LanguageServerPlugin.logWarning("Changes outside of visible projects are not supported at the moment.", null);
                        return;
                    }
                    if (!(resourceOperation instanceof RenameFile)) return;
                    oldURI = URI.create(((RenameFile)resourceOperation).getOldUri());
                    newURI = URI.create(((RenameFile)resourceOperation).getNewUri());
                    oldFile = LSPEclipseUtils.getFileHandle(oldURI.toString());
                    IFile newFile = LSPEclipseUtils.getFileHandle(newURI.toString());
                    removeNewFile = null;
                    if (newFile != null && newFile.exists()) {
                        if (((RenameFile)resourceOperation).getOptions().getOverwrite().booleanValue()) {
                            removeNewFile = new DeleteResourceChange(newFile.getFullPath(), true);
                        } else if (((RenameFile)resourceOperation).getOptions().getIgnoreIfExists().booleanValue()) {
                            return;
                        }
                    }
                    content = "";
                    encoding = null;
                    if (oldFile != null && oldFile.exists()) {
                        try {
                            Throwable throwable = null;
                            Object var11_24 = null;
                            try {
                                ByteArrayOutputStream stream = new ByteArrayOutputStream((int)oldFile.getLocation().toFile().length());
                                try {
                                    try (InputStream inputStream = oldFile.getContents();){
                                        FileUtil.transferStreams((InputStream)inputStream, (OutputStream)stream, (String)newURI.toString(), null);
                                        content = new String(stream.toByteArray());
                                        encoding = oldFile.getCharset();
                                    }
                                    if (stream == null) break block27;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (stream == null) throw throwable;
                                    stream.close();
                                    throw throwable;
                                }
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                    throw throwable;
                                }
                                if (throwable == throwable3) throw throwable;
                                throwable.addSuppressed(throwable3);
                                throw throwable;
                            }
                        }
                        catch (IOException | CoreException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    }
                }
                CreateFileChange createFileChange = new CreateFileChange(newURI, content, encoding);
                change.add((Change)createFileChange);
                if (removeNewFile != null) {
                    change.add((Change)removeNewFile);
                }
                if (oldFile != null) {
                    DeleteResourceChange removeOldFile = new DeleteResourceChange(oldFile.getFullPath(), true);
                    change.add((Change)removeOldFile);
                    return;
                }
                change.add((Change)new DeleteExternalFile(new File(oldURI)));
            });
        } else {
            Map changes = wsEdit.getChanges();
            if (changes != null) {
                for (Map.Entry edit : changes.entrySet()) {
                    URI uri = URI.create((String)edit.getKey());
                    List textEdits = (List)edit.getValue();
                    change.addAll((Change[])LSPEclipseUtils.toChanges(uri, textEdits));
                }
            }
        }
        return change;
    }

    private static LSPTextChange[] toChanges(URI uri, List<org.eclipse.lsp4j.TextEdit> textEdits) {
        Collections.sort(textEdits, Comparator.comparing(edit -> edit.getRange().getStart(), Comparator.comparingInt(Position::getLine).thenComparingInt(Position::getCharacter).reversed()));
        return (LSPTextChange[])textEdits.stream().map(te -> new LSPTextChange("LSP Text Edit", uri, (org.eclipse.lsp4j.TextEdit)te)).toArray(LSPTextChange[]::new);
    }

    public static URI toUri(IPath absolutePath) {
        return LSPEclipseUtils.toUri(absolutePath.toFile());
    }

    public static URI toUri(IResource resource) {
        IPath location = resource.getLocation();
        if (location != null) {
            return LSPEclipseUtils.toUri(location);
        }
        return null;
    }

    public static URI toUri(File file) {
        try {
            return new URI("file", "", file.getAbsoluteFile().toURI().getPath(), null);
        }
        catch (URISyntaxException e) {
            LanguageServerPlugin.logError(e);
            return file.getAbsoluteFile().toURI();
        }
    }

    public static @Nullable IFile getFile(IDocument document) {
        IPath path = LSPEclipseUtils.toPath(document);
        if (path == null) {
            return null;
        }
        IFile res = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (res != null && res.exists()) {
            return res;
        }
        return null;
    }

    public static @NonNull WorkspaceFolder toWorkspaceFolder(@NonNull IProject project) {
        WorkspaceFolder folder = new WorkspaceFolder();
        folder.setUri(project.getLocationURI().toString());
        folder.setName(project.getName());
        return folder;
    }

    public static @NonNull List<IContentType> getFileContentTypes(@NonNull IFile file) {
        ArrayList<IContentType> contentTypes = new ArrayList<IContentType>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream contents = file.getContents();){
                contentTypes.addAll(Arrays.asList(Platform.getContentTypeManager().findContentTypesFor(contents, file.getName())));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            LanguageServerPlugin.logError(e);
        }
        return contentTypes;
    }

    public static @NonNull List<IContentType> getDocumentContentTypes(@NonNull IDocument document) {
        ArrayList<IContentType> contentTypes = new ArrayList<IContentType>();
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return Collections.emptyList();
        }
        String fileName = new File(uri).getName();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (DocumentInputStream contents = new DocumentInputStream(document);){
                contentTypes.addAll(Arrays.asList(Platform.getContentTypeManager().findContentTypesFor((InputStream)contents, fileName)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LanguageServerPlugin.logError(e);
        }
        return contentTypes;
    }

    @Deprecated
    public static String getDocString(Either<String, MarkupContent> documentation) {
        if (documentation != null) {
            if (documentation.isLeft()) {
                return (String)documentation.getLeft();
            }
            return ((MarkupContent)documentation.getRight()).getValue();
        }
        return null;
    }

    public static String getHtmlDocString(Either<String, MarkupContent> documentation) {
        MarkupContent markupContent;
        if (documentation.isLeft()) {
            return LSPEclipseUtils.htmlParagraph((String)documentation.getLeft());
        }
        if (documentation.isRight() && (markupContent = (MarkupContent)documentation.getRight()).getValue() != null) {
            if (MARKDOWN.equalsIgnoreCase(markupContent.getKind()) || MD.equalsIgnoreCase(markupContent.getKind())) {
                try {
                    return MARKDOWN_PARSER.parseToHtml(markupContent.getValue());
                }
                catch (Exception e) {
                    LanguageServerPlugin.logError(e);
                    return LSPEclipseUtils.htmlParagraph(markupContent.getValue());
                }
            }
            if (HTML.equalsIgnoreCase(markupContent.getKind())) {
                return markupContent.getValue();
            }
            return LSPEclipseUtils.htmlParagraph(markupContent.getValue());
        }
        return null;
    }

    private static String htmlParagraph(String text) {
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        sb.append(text);
        sb.append("</p>");
        return sb.toString();
    }

    public static Color toColor(RGB rgb) {
        return new Color((double)rgb.red / 255.0, (double)rgb.green / 255.0, (double)rgb.blue / 255.0, 1.0);
    }

    public static RGBA toRGBA(Color color) {
        return new RGBA((int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), (int)color.getAlpha());
    }

    public static Set<IEditorReference> findOpenEditorsFor(URI uri) {
        if (uri == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(PlatformUI.getWorkbench().getWorkbenchWindows()).map(IWorkbenchWindow::getPages).flatMap(Arrays::stream).map(IWorkbenchPage::getEditorReferences).flatMap(Arrays::stream).filter(ref -> {
            try {
                return uri.equals(LSPEclipseUtils.toUri(ref.getEditorInput()));
            }
            catch (PartInitException e) {
                LanguageServerPlugin.logError(e);
                return false;
            }
        }).collect(Collectors.toSet());
    }

    private static URI toUri(IEditorInput editorInput) {
        if (editorInput instanceof FileEditorInput) {
            return LSPEclipseUtils.toUri((IResource)((FileEditorInput)editorInput).getFile());
        }
        if (editorInput instanceof IURIEditorInput) {
            return LSPEclipseUtils.toUri(Path.fromPortableString((String)((IURIEditorInput)editorInput).getURI().getPath()));
        }
        return null;
    }

    public static URI toUri(String uri) {
        return LSPEclipseUtils.toUri(Path.fromPortableString((String)URI.create(uri).getPath()));
    }
}

