/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class MockConnectionProvider
implements StreamConnectionProvider {
    private InputStream inputStream;
    private OutputStream outputStream;
    private InputStream errorStream;

    public void start() throws IOException {
        PipedInputStream clientInput = new PipedInputStream();
        PipedOutputStream clientOutput = new PipedOutputStream();
        PipedInputStream serverInput = new PipedInputStream();
        PipedOutputStream serverOutput = new PipedOutputStream();
        this.errorStream = new ByteArrayInputStream("Error output on console".getBytes(StandardCharsets.UTF_8));
        clientInput.connect(serverOutput);
        clientOutput.connect(serverInput);
        Launcher l = LSPLauncher.createServerLauncher((LanguageServer)MockLanguageServer.INSTANCE, (InputStream)serverInput, (OutputStream)serverOutput);
        this.inputStream = clientInput;
        this.outputStream = clientOutput;
        l.startListening();
        MockLanguageServer.INSTANCE.addRemoteProxy((LanguageClient)l.getRemoteProxy());
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public void stop() {
    }
}

