/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.color;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.util.Collections;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ColorTest {
    @Rule
    public AllCleanRule cleanRule = new AllCleanRule();
    private RGB color;

    @Before
    public void setUp() {
        this.color = new RGB(56, 78, 90);
        MockLanguageServer.INSTANCE.getTextDocumentService().setDocumentColors(Collections.singletonList(new ColorInformation(new Range(new Position(0, 0), new Position(0, 1)), new Color((double)this.color.red / 255.0, (double)this.color.green / 255.0, (double)this.color.blue / 255.0, 0.0))));
    }

    @Test
    public void testColorProvider() throws Exception {
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(TestUtils.createProject("testColorProvider"), "a"));
        final StyledText widget = viewer.getTextWidget();
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return ColorTest.containsColor((Control)widget, ColorTest.this.color);
            }
        }.waitForCondition(widget.getDisplay(), 3000L));
    }

    @Test
    public void testColorProviderExternalFile() throws Exception {
        File file = File.createTempFile("testColorProviderExternalFile", ".lspt");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                out.write(97);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ITextViewer viewer = TestUtils.getTextViewer(IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI())));
            final StyledText widget = viewer.getTextWidget();
            Assert.assertTrue((boolean)new DisplayHelper(){

                protected boolean condition() {
                    return ColorTest.containsColor((Control)widget, ColorTest.this.color);
                }
            }.waitForCondition(widget.getDisplay(), 3000L));
        }
        finally {
            Files.deleteIfExists(file.toPath());
        }
    }

    public static boolean containsColor(Control widget, RGB expectedRGB) {
        if (widget.getSize().x == 0) {
            return false;
        }
        GC gc = new GC((Drawable)widget);
        Image image = new Image((Device)widget.getDisplay(), widget.getSize().x, widget.getSize().y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        ImageData imageData = image.getImageData();
        int x = 0;
        while (x < image.getBounds().width) {
            int y = 0;
            while (y < image.getBounds().height) {
                RGB pixelRGB = imageData.palette.getRGB(imageData.getPixel(x, y));
                if (expectedRGB.equals((Object)pixelRGB)) {
                    image.dispose();
                    return true;
                }
                ++y;
            }
            ++x;
        }
        image.dispose();
        return false;
    }
}

