/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.debugmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.lsp4e.debug.DSPPlugin;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugElement;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4e.debug.debugmodel.DSPStackFrame;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.PauseArguments;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.Thread;

public class DSPThread
extends DSPDebugElement
implements IThread {
    private final Long id;
    private String name;
    private List<DSPStackFrame> frames = Collections.synchronizedList(new ArrayList());
    private AtomicBoolean refreshFrames = new AtomicBoolean(true);
    private boolean stepping;
    private boolean isSuspended = false;

    public DSPThread(DSPDebugTarget debugTarget, Thread thread) {
        super(debugTarget);
        this.id = thread.getId();
        this.name = thread.getName();
    }

    public DSPThread(DSPDebugTarget debugTarget, Long threadId) {
        super(debugTarget);
        this.id = threadId;
    }

    public void update(Thread thread) {
        Assert.isTrue((boolean)Objects.equals(this.id, thread.getId()));
        this.name = thread.getName();
        this.refreshFrames.set(true);
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    private <T> T handleExceptionalResume(Throwable t) {
        DSPPlugin.logError("Failed to resume debug adapter", t);
        this.setErrorMessage(t.getMessage());
        this.stopped();
        this.fireSuspendEvent(32);
        return null;
    }

    public void continued() {
        this.isSuspended = false;
        this.refreshFrames.set(true);
    }

    public void stopped() {
        this.isSuspended = true;
        this.stepping = false;
        this.refreshFrames.set(true);
    }

    public void stepReturn() throws DebugException {
        this.continued();
        this.stepping = true;
        this.fireResumeEvent(2);
        StepOutArguments arguments = new StepOutArguments();
        arguments.setThreadId(this.id);
        this.getDebugProtocolServer().stepOut(arguments).exceptionally(this::handleExceptionalResume);
    }

    public void stepOver() throws DebugException {
        this.continued();
        this.stepping = true;
        this.fireResumeEvent(2);
        NextArguments arguments = new NextArguments();
        arguments.setThreadId(this.id);
        this.getDebugProtocolServer().next(arguments).exceptionally(this::handleExceptionalResume);
    }

    public void stepInto() throws DebugException {
        this.continued();
        this.stepping = true;
        this.fireResumeEvent(1);
        StepInArguments arguments = new StepInArguments();
        arguments.setThreadId(this.id);
        this.getDebugProtocolServer().stepIn(arguments).exceptionally(this::handleExceptionalResume);
    }

    public void resume() throws DebugException {
        this.continued();
        this.stepping = true;
        this.fireResumeEvent(1);
        ContinueArguments arguments = new ContinueArguments();
        arguments.setThreadId(this.id);
        ((CompletableFuture)this.getDebugProtocolServer().continue_(arguments).thenAccept(response -> {
            if (response == null || response.getAllThreadsContinued() == null || response.getAllThreadsContinued().booleanValue()) {
                this.getDebugTarget().fireResumeEvent(32);
            }
        })).exceptionally(this::handleExceptionalResume);
    }

    public boolean isStepping() {
        return this.stepping;
    }

    private boolean canResumeOrStep() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.canResumeOrStep();
    }

    public boolean canStepOver() {
        return this.canResumeOrStep();
    }

    public boolean canStepInto() {
        return this.canResumeOrStep();
    }

    public boolean canResume() {
        return this.canResumeOrStep();
    }

    public void suspend() throws DebugException {
        PauseArguments arguments = new PauseArguments();
        arguments.setThreadId(this.id);
        this.getDebugProtocolServer().pause(arguments).exceptionally(t -> {
            DSPPlugin.logError("Failed to suspend debug adapter", t);
            this.setErrorMessage(t.getMessage());
            this.fireChangeEvent(256);
            return null;
        });
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    @Override
    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] stackFrames = this.getStackFrames();
        if (stackFrames.length > 0) {
            return stackFrames[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStackFrame[] getStackFrames() throws DebugException {
        if (!this.refreshFrames.getAndSet(false)) {
            List<DSPStackFrame> list = this.frames;
            synchronized (list) {
                return this.frames.toArray(new DSPStackFrame[this.frames.size()]);
            }
        }
        try {
            StackTraceArguments arguments = new StackTraceArguments();
            arguments.setThreadId(this.id);
            arguments.setStartFrame(Long.valueOf(0L));
            arguments.setLevels(Long.valueOf(20L));
            CompletionStage future = this.getDebugTarget().getDebugProtocolServer().stackTrace(arguments).thenApply(response -> {
                List<DSPStackFrame> list = this.frames;
                synchronized (list) {
                    StackFrame[] backendFrames = response.getStackFrames();
                    int i = 0;
                    while (i < backendFrames.length) {
                        if (i < this.frames.size()) {
                            this.frames.set(i, this.frames.get(i).replace(backendFrames[i], i));
                        } else {
                            this.frames.add(new DSPStackFrame(this, backendFrames[i], i));
                        }
                        ++i;
                    }
                    this.frames.subList(backendFrames.length, this.frames.size()).clear();
                    return this.frames.toArray(new DSPStackFrame[this.frames.size()]);
                }
            });
            return (IStackFrame[])((CompletableFuture)future).get();
        }
        catch (RuntimeException | ExecutionException e) {
            if (this.isTerminated()) {
                return new DSPStackFrame[0];
            }
            throw DSPThread.newTargetRequestFailedException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            java.lang.Thread.currentThread().interrupt();
            return new DSPStackFrame[0];
        }
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public String getName() {
        if (this.name == null) {
            this.getDebugTarget().getThreads();
            return "<pending>";
        }
        return this.name;
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    public Long getId() {
        return this.id;
    }
}

