/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.codeactions;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.NoErrorLoggedRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CodeActionTests {
    @Rule
    public NoErrorLoggedRule rule = new NoErrorLoggedRule(LanguageServerPlugin.getDefault().getLog());
    @Rule
    public AllCleanRule clear = new AllCleanRule();

    @Test
    public void testCodeActionsClientCommandForTextEdit() throws CoreException {
        IProject p = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile f = TestUtils.createUniqueTestFile(p, "error");
        MockLanguageServer.INSTANCE.setCodeActions(Collections.singletonList(Either.forLeft((Object)new Command("fixme", "edit", Collections.singletonList(new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed"))))));
        MockLanguageServer.INSTANCE.setDiagnostics(Collections.singletonList(new Diagnostic(new Range(new Position(0, 0), new Position(0, 5)), "error", DiagnosticSeverity.Error, null)));
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        try {
            IMarker m = CodeActionTests.assertDiagnostics(f, "error", "fixme");
            CodeActionTests.assertResolution(editor, m, "fixed");
        }
        finally {
            editor.close(false);
            p.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Test
    public void testCodeActionsClientCommandForWorkspaceEdit() throws CoreException {
        IProject p = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile f = TestUtils.createUniqueTestFile(p, "error");
        TextEdit tEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed");
        WorkspaceEdit wEdit = new WorkspaceEdit(Collections.singletonMap(f.getLocationURI().toString(), Collections.singletonList(tEdit)));
        MockLanguageServer.INSTANCE.setCodeActions(Collections.singletonList(Either.forLeft((Object)new Command("fixme", "edit", Collections.singletonList(wEdit)))));
        MockLanguageServer.INSTANCE.setDiagnostics(Collections.singletonList(new Diagnostic(new Range(new Position(0, 0), new Position(0, 5)), "error", DiagnosticSeverity.Error, null)));
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        try {
            IMarker m = CodeActionTests.assertDiagnostics(f, "error", "fixme");
            CodeActionTests.assertResolution(editor, m, "fixed");
        }
        finally {
            editor.close(false);
            p.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Test
    public void testCodeActionLiteralWorkspaceEdit() throws CoreException {
        IProject p = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile f = TestUtils.createUniqueTestFile(p, "error");
        TextEdit tEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed");
        WorkspaceEdit wEdit = new WorkspaceEdit(Collections.singletonMap(f.getLocationURI().toString(), Collections.singletonList(tEdit)));
        CodeAction codeAction = new CodeAction("fixme");
        codeAction.setEdit(wEdit);
        MockLanguageServer.INSTANCE.setCodeActions(Collections.singletonList(Either.forRight((Object)codeAction)));
        MockLanguageServer.INSTANCE.setDiagnostics(Collections.singletonList(new Diagnostic(new Range(new Position(0, 0), new Position(0, 5)), "error", DiagnosticSeverity.Error, null)));
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        try {
            IMarker m = CodeActionTests.assertDiagnostics(f, "error", "fixme");
            CodeActionTests.assertResolution(editor, m, "fixed");
        }
        finally {
            editor.close(false);
            p.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Test
    public void testCodeActionLiteralWithClientCommand() throws CoreException {
        IProject p = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile f = TestUtils.createUniqueTestFile(p, "error");
        TextEdit tEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed");
        WorkspaceEdit wEdit = new WorkspaceEdit(Collections.singletonMap(f.getLocationURI().toString(), Collections.singletonList(tEdit)));
        CodeAction codeAction = new CodeAction("fixme");
        codeAction.setCommand(new Command("editCommand", "mockEditCommand", Collections.singletonList(wEdit)));
        MockLanguageServer.INSTANCE.setCodeActions(Collections.singletonList(Either.forRight((Object)codeAction)));
        MockLanguageServer.INSTANCE.setDiagnostics(Collections.singletonList(new Diagnostic(new Range(new Position(0, 0), new Position(0, 5)), "error", DiagnosticSeverity.Error, null)));
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        try {
            IMarker m = CodeActionTests.assertDiagnostics(f, "error", "fixme");
            CodeActionTests.assertResolution(editor, m, "fixed");
        }
        finally {
            editor.close(false);
            p.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static IMarker assertDiagnostics(final IFile f, String markerMessage, final String resolutionLabel) throws CoreException {
        new DisplayHelper(){

            protected boolean condition() {
                try {
                    IMarker[] markers = f.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
                    return markers.length > 0 && markers[0].getAttribute("message") != null;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(Display.getCurrent(), 2000L);
        final IMarker m = f.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0)[0];
        Assert.assertEquals((Object)markerMessage, (Object)m.getAttribute("message"));
        new DisplayHelper(){

            protected boolean condition() {
                return IDE.getMarkerHelpRegistry().hasResolutions(m) && IDE.getMarkerHelpRegistry().getResolutions(m)[0].getLabel().equals(resolutionLabel);
            }
        }.waitForCondition(Display.getCurrent(), 2000L);
        return m;
    }

    public static void assertResolution(final AbstractTextEditor editor, IMarker m, final String newText) {
        IDE.getMarkerHelpRegistry().getResolutions(m)[0].run(m);
        new DisplayHelper(){

            protected boolean condition() {
                return newText.equals(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
            }
        }.waitForCondition(Display.getCurrent(), 1000L);
        Assert.assertEquals((Object)newText, (Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
        new DisplayHelper(){

            protected boolean condition() {
                return newText.equals(((StyledText)editor.getAdapter(Control.class)).getText());
            }
        }.waitForCondition(Display.getCurrent(), 1000L);
        Assert.assertEquals((Object)newText, (Object)((StyledText)editor.getAdapter(Control.class)).getText());
    }
}

