/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.declaration;

import org.eclipse.lsp4e.operations.declaration.LSBasedHyperlink;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.junit.Assert;
import org.junit.Test;

public class LSBasedHyperlinkTest {
    @Test
    public void testHyperlinkLabelNoLocation() {
        Location location = new Location();
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null);
        Assert.assertEquals((Object)"Open Declaration", (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForFileLocation() {
        Location location = new Location();
        location.setUri("file:///Users/someuser/testfile");
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null);
        Assert.assertEquals((Object)"Open Declaration - /Users/someuser/testfile", (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForFileLocationLink() {
        LocationLink location = new LocationLink();
        location.setTargetUri("file:///Users/someuser/testfile");
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null);
        Assert.assertEquals((Object)"Open Declaration - /Users/someuser/testfile", (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForIntroBasedLocationWithoutLabel() {
        Location location = new Location();
        location.setUri("http://org.eclipse.ui.intro/execute?command=mycommand%28bindingKey%3DLorg%2Ftest%2Fmvctest%2FMyComponent%3B%2CprojectName%3Dmvctest%29");
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null);
        Assert.assertEquals((Object)"Open Declaration", (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForIntroBasedLocationLinkWithLabel() {
        LocationLink location = new LocationLink();
        location.setTargetUri("http://org.eclipse.ui.intro/execute?command=org.springframework.tooling.ls.eclipse.commons.commands.OpenJavaElementInEditor%28bindingKey%3DLorg%2Ftest%2Fmvctest%2FMyComponent%3B%2CprojectName%3Dmvctest%29&label=MyComponent+-+org.test.mvctest");
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null);
        Assert.assertEquals((Object)"Open Declaration - MyComponent - org.test.mvctest", (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForRandomURLLocation() {
        Location location = new Location();
        location.setUri("http://eclipse.org");
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null);
        Assert.assertEquals((Object)"Open Declaration - http://eclipse.org", (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForRandomURLLocationLink() {
        LocationLink location = new LocationLink();
        location.setTargetUri("http://eclipse.org");
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null);
        Assert.assertEquals((Object)"Open Declaration - http://eclipse.org", (Object)hyperlink.getHyperlinkText());
    }
}

