/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.diagnostics;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntSupplier;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.lsp4e.operations.diagnostics.LSPDiagnosticsToMarkers;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.test.color.ColorTest;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DiagnosticsTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;
    private LSPDiagnosticsToMarkers diagnosticsToMarkers;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("DiagnoticsTest" + System.currentTimeMillis());
        this.diagnosticsToMarkers = new LSPDiagnosticsToMarkers("dummy");
    }

    @Test
    public void testDiagnostics() throws CoreException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Diagnostic Other Text");
        Range range = new Range(new Position(0, 0), new Position(0, 10));
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        diagnostics.add(this.createDiagnostic("1", "message1", range, DiagnosticSeverity.Error, "source1"));
        diagnostics.add(this.createDiagnostic("2", "message2", range, DiagnosticSeverity.Warning, "source2"));
        diagnostics.add(this.createDiagnostic("3", "message3", range, DiagnosticSeverity.Information, "source3"));
        diagnostics.add(this.createDiagnostic("4", "message4", range, DiagnosticSeverity.Hint, "source4"));
        this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(file.getLocationURI().toString(), diagnostics));
        IMarker[] markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2);
        Assert.assertEquals((long)diagnostics.size(), (long)markers.length);
        int i = 0;
        while (i < diagnostics.size()) {
            Diagnostic diagnostic = (Diagnostic)diagnostics.get(i);
            IMarker marker = markers[i];
            Assert.assertEquals((Object)diagnostic.getMessage(), (Object)MarkerUtilities.getMessage((IMarker)marker));
            Assert.assertEquals((long)0L, (long)MarkerUtilities.getCharStart((IMarker)marker));
            Assert.assertEquals((long)10L, (long)MarkerUtilities.getCharEnd((IMarker)marker));
            Assert.assertEquals((long)1L, (long)MarkerUtilities.getLineNumber((IMarker)marker));
            Assert.assertEquals((Object)marker.getAttribute("lspDiagnostic"), (Object)diagnostic);
            ++i;
        }
        this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(file.getLocationURI().toString(), Collections.emptyList()));
        markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2);
        Assert.assertEquals((long)0L, (long)markers.length);
    }

    @Test
    public void testDiagnosticsRangeAfterDocument() throws CoreException {
        String content = "Diagnostic Other Text";
        IFile file = TestUtils.createUniqueTestFile(this.project, content);
        Range range = new Range(new Position(1, 0), new Position(1, 5));
        List<Diagnostic> diagnostics = Collections.singletonList(this.createDiagnostic("1", "message1", range, DiagnosticSeverity.Error, "source1"));
        this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(file.getLocationURI().toString(), diagnostics));
        IMarker[] markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2);
        Assert.assertEquals((long)diagnostics.size(), (long)markers.length);
        int i = 0;
        while (i < diagnostics.size()) {
            Diagnostic diagnostic = diagnostics.get(i);
            IMarker marker = markers[i];
            Assert.assertEquals((Object)diagnostic.getMessage(), (Object)MarkerUtilities.getMessage((IMarker)marker));
            Assert.assertEquals((long)content.length(), (long)MarkerUtilities.getCharStart((IMarker)marker));
            Assert.assertEquals((long)content.length(), (long)MarkerUtilities.getCharEnd((IMarker)marker));
            Assert.assertEquals((long)1L, (long)MarkerUtilities.getLineNumber((IMarker)marker));
            Assert.assertEquals((Object)marker.getAttribute("lspDiagnostic"), (Object)diagnostic);
            ++i;
        }
    }

    @Test
    public void testDiagnosticsFromVariousLS() throws Exception {
        String content = "Diagnostic Other Text";
        IFile file = TestUtils.createUniqueTestFileMultiLS(this.project, content);
        Range range = new Range(new Position(1, 0), new Position(1, 0));
        MockLanguageServer.INSTANCE.setDiagnostics(Collections.singletonList(this.createDiagnostic("1", "message1", range, DiagnosticSeverity.Error, "source1")));
        IMarker[] markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
        Assert.assertEquals((String)"no marker should be shown at file initialization", (long)0L, (long)markers.length);
        TestUtils.openEditor(file);
        Thread.sleep(300L);
        markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
        Assert.assertEquals((String)"there should be 1 marker for each language server", (long)2L, (long)markers.length);
    }

    @Test
    public void testDiagnosticRedrawingCalls() throws CoreException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Diagnostic Other Text\nDiagnostic Other Text");
        Range range1 = new Range(new Position(0, 0), new Position(0, 10));
        Range range2 = new Range(new Position(1, 0), new Position(1, 10));
        Diagnostic pos1Info1 = this.createDiagnostic("1", "message1", range1, DiagnosticSeverity.Error, "source1");
        Diagnostic pos1Info2 = this.createDiagnostic("2", "message2", range1, DiagnosticSeverity.Error, "source2");
        Diagnostic pos2Info2 = this.createDiagnostic("2", "message2", range2, DiagnosticSeverity.Error, "source2");
        this.confirmResourceChanges(file, pos1Info1, 1);
        this.confirmResourceChanges(file, pos1Info2, 1);
        this.confirmResourceChanges(file, pos2Info2, 1);
        this.confirmResourceChanges(file, pos1Info1, 1);
        this.confirmResourceChanges(file, pos1Info1, 0);
    }

    @Test
    public void testDiagnosticsOnExternalFile() throws Exception {
        MockLanguageServer.INSTANCE.setDiagnostics(Collections.singletonList(new Diagnostic(new Range(new Position(0, 0), new Position(0, 1)), "This is a warning", DiagnosticSeverity.Warning, null)));
        File file = File.createTempFile("testDiagnosticsOnExternalFile", ".lspt");
        Font font = null;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                out.write(97);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ITextViewer viewer = TestUtils.getTextViewer(IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI())));
            final StyledText widget = viewer.getTextWidget();
            FontData biggerFont = new FontData();
            biggerFont.setHeight(40);
            biggerFont.setLocale(widget.getFont().getFontData()[0].getLocale());
            biggerFont.setName(widget.getFont().getFontData()[0].getName());
            biggerFont.setStyle(widget.getFont().getFontData()[0].getStyle());
            font = new Font((Device)widget.getDisplay(), biggerFont);
            widget.setFont(font);
            final RGB warningColor = new RGB(244, 200, 45);
            Assert.assertTrue((boolean)new DisplayHelper(){

                protected boolean condition() {
                    return ColorTest.containsColor((Control)widget, warningColor);
                }
            }.waitForCondition(widget.getDisplay(), 3000L));
        }
        finally {
            Files.deleteIfExists(file.toPath());
            if (font != null) {
                font.dispose();
            }
        }
    }

    private void confirmResourceChanges(final IFile file, final Diagnostic diagnostic, int expectedChanges) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        MarkerRedrawCountListener redrawCountListener = new MarkerRedrawCountListener();
        workspace.addResourceChangeListener((IResourceChangeListener)redrawCountListener);
        try {
            this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(file.getLocationURI().toString(), Collections.singletonList(diagnostic)));
            new DisplayHelper(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected boolean condition() {
                    try {
                        IMarker[] markers;
                        IMarker[] iMarkerArray = markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2);
                        int n = markers.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                return false;
                            }
                            IMarker marker = iMarkerArray[n2];
                            if (marker.getAttribute("lspDiagnostic").equals(diagnostic)) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    return false;
                }
            }.waitForCondition(Display.getCurrent(), 5000L);
            Assert.assertEquals((long)expectedChanges, (long)redrawCountListener.getAsInt());
        }
        finally {
            workspace.removeResourceChangeListener((IResourceChangeListener)redrawCountListener);
        }
    }

    private Diagnostic createDiagnostic(String code, String message, Range range, DiagnosticSeverity severity, String source) {
        Diagnostic diagnostic = new Diagnostic();
        diagnostic.setCode(code);
        diagnostic.setMessage(message);
        diagnostic.setRange(range);
        diagnostic.setSeverity(severity);
        diagnostic.setSource(source);
        return diagnostic;
    }

    private class MarkerRedrawCountListener
    implements IResourceChangeListener,
    IntSupplier {
        private int resourceChanges = 0;

        private MarkerRedrawCountListener() {
        }

        @Override
        public int getAsInt() {
            return this.resourceChanges;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResourceDelta[] childDeltas = delta.getAffectedChildren();
            if (childDeltas.length == 0) {
                return;
            }
            if ((childDeltas = childDeltas[0].getAffectedChildren()).length == 0 || childDeltas[0].getMarkerDeltas().length == 0) {
                return;
            }
            ++this.resourceChanges;
        }
    }
}

