/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.outline;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.outline.CNFOutlinePage;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class OutlineContentTest {
    @Rule
    public AllCleanRule rule = new AllCleanRule();

    @Test
    public void testNodeRemainExpandedUponSelection() throws CoreException {
        IProject project = TestUtils.createProject("EditorToOutlineAdapterFactoryTest" + System.currentTimeMillis());
        IFile testFile = TestUtils.createUniqueTestFile(project, "a(b())");
        MockLanguageServer.INSTANCE.setDocumentSymbols(new DocumentSymbol("a", SymbolKind.Constant, new Range(new Position(0, 0), new Position(0, 6)), new Range(new Position(0, 0), new Position(0, 1)), "", Collections.singletonList(new DocumentSymbol("b", SymbolKind.Constant, new Range(new Position(0, 2), new Position(0, 5)), new Range(new Position(0, 2), new Position(0, 3))))));
        ITextEditor editor = (ITextEditor)TestUtils.openEditor(testFile);
        CNFOutlinePage outlinePage = new CNFOutlinePage((LanguageServer)MockLanguageServer.INSTANCE, editor);
        Shell shell = new Shell(editor.getEditorSite().getWorkbenchWindow().getShell());
        shell.setLayout((Layout)new FillLayout());
        outlinePage.createControl((Composite)shell);
        shell.open();
        final Tree tree = (Tree)outlinePage.getControl();
        editor.getSelectionProvider().setSelection((ISelection)new TextSelection(4, 0));
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return OutlineContentTest.this.itemBselectedAndVisibile(tree);
            }
        }.waitForCondition(tree.getDisplay(), 2000L));
        editor.getSelectionProvider().setSelection((ISelection)new TextSelection(3, 0));
        Assert.assertFalse((boolean)new DisplayHelper(){

            protected boolean condition() {
                return !OutlineContentTest.this.itemBselectedAndVisibile(tree);
            }
        }.waitForCondition(tree.getDisplay(), 2000L));
    }

    private boolean itemBselectedAndVisibile(Tree tree) {
        if (tree.getSelection().length == 0) {
            return false;
        }
        TreeItem selection = tree.getSelection()[0];
        return selection != null && selection.getText().equals("b") && selection.getParentItem().getExpanded();
    }
}

