/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.launcher;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.lsp4e.debug.DSPPlugin;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.osgi.util.NLS;

public class DSPLaunchDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean launchNotConnect = "launch server".equals(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "launch server"));
        String dspParametersJson = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_PARAM", null);
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map dspParameters = (Map)gson.fromJson(dspParametersJson, type);
        if ("debug".equals(mode)) {
            subMonitor.setTaskName("Starting debug session");
            dspParameters.put("noDebug", false);
        } else if ("run".equals(mode)) {
            subMonitor.setTaskName("Starting run session");
            dspParameters.put("noDebug", true);
        } else {
            this.abort(NLS.bind((String)"Unsupported launch mode '{0}'.", (Object)mode), null);
        }
        try {
            try {
                Runnable cleanup;
                OutputStream outputStream;
                InputStream inputStream;
                if (launchNotConnect) {
                    ArrayList<String> command = new ArrayList<String>();
                    String debugCmd = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", null);
                    if (debugCmd == null) {
                        this.abort("Debug command unspecified.", null);
                    }
                    command.add(debugCmd);
                    List debugArgs = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", null);
                    if (debugArgs != null && !debugArgs.isEmpty()) {
                        command.addAll(debugArgs);
                    }
                    ProcessBuilder processBuilder = new ProcessBuilder(command);
                    subMonitor.subTask(NLS.bind((String)"Launching debug adapter: {0}", (Object)("\"" + String.join((CharSequence)"\" \"", command) + "\"")));
                    final Process debugAdapterProcess = processBuilder.start();
                    if (launch.getLaunchConfiguration().getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false)) {
                        String initialCaptureOutput = launch.getAttribute("org.eclipse.debug.core.capture_output");
                        launch.setAttribute("org.eclipse.debug.core.capture_output", Boolean.toString(true));
                        final IProcess debugAdapterIProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)debugAdapterProcess, (String)"Debug Adapter");
                        launch.setAttribute("org.eclipse.debug.core.capture_output", initialCaptureOutput);
                        final List bytes = Collections.synchronizedList(new LinkedList());
                        inputStream = new InputStream(){

                            @Override
                            public int read() throws IOException {
                                while (debugAdapterProcess.isAlive()) {
                                    if (!bytes.isEmpty()) {
                                        return ((Byte)bytes.remove(0)).byteValue();
                                    }
                                    try {
                                        Thread.sleep(50L);
                                    }
                                    catch (InterruptedException e) {
                                        DSPPlugin.logError(e);
                                    }
                                }
                                return -1;
                            }
                        };
                        debugAdapterIProcess.getStreamsProxy().getOutputStreamMonitor().addListener(new IStreamListener(){

                            public void streamAppended(String text, IStreamMonitor monitor) {
                                try {
                                    byte[] byArray = text.getBytes(launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING"));
                                    int n = byArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        byte b = byArray[n2];
                                        bytes.add(b);
                                        ++n2;
                                    }
                                }
                                catch (IOException e) {
                                    DSPPlugin.logError(e);
                                }
                            }
                        });
                        outputStream = new OutputStream(){

                            @Override
                            public void write(int b) throws IOException {
                                debugAdapterIProcess.getStreamsProxy().write(new String(new byte[]{(byte)b}));
                            }
                        };
                        cleanup = () -> {
                            try {
                                debugAdapterIProcess.terminate();
                                debugAdapterProcess.destroy();
                            }
                            catch (DebugException e) {
                                DSPPlugin.logError(e);
                            }
                        };
                    } else {
                        inputStream = debugAdapterProcess.getInputStream();
                        outputStream = debugAdapterProcess.getOutputStream();
                        cleanup = () -> debugAdapterProcess.destroy();
                    }
                } else {
                    int port;
                    String server = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_HOST", null);
                    if (server == null) {
                        this.abort("Debug server host unspecified.", null);
                    }
                    if ((port = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_PORT", 0)) < 1 || port > 65535) {
                        this.abort("Debug server port unspecified or out of range 1-65535.", null);
                    }
                    subMonitor.subTask(NLS.bind((String)"Connecting to debug adapter: {0}:{1}", (Object)server, (Object)port));
                    Socket socket = new Socket(server, port);
                    inputStream = socket.getInputStream();
                    outputStream = socket.getOutputStream();
                    cleanup = () -> {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    };
                }
                subMonitor.setWorkRemaining(80);
                DSPDebugTarget target = new DSPDebugTarget(launch, cleanup, inputStream, outputStream, dspParameters);
                target.initialize((IProgressMonitor)subMonitor.split(80));
                launch.addDebugTarget((IDebugTarget)target);
            }
            catch (IOException | OperationCanceledException e1) {
                this.abort("Failed to start debugging", e1);
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
    }

    private void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4e.debug", 0, message, e));
    }
}

