/*******************************************************************************
 * Copyright (c) 2017 Pivotal Inc. and others.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Martin Lippert (Pivotal Inc.) - initial implementation
 *******************************************************************************/
package org.eclipse.lsp4e.test.edit;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DocumentDidOpenTest {

	private IProject project;

	@Before
	public void setUp() throws CoreException {
		project =  TestUtils.createProject(getClass().getName() + System.currentTimeMillis());
	}

	@After
	public void tearDown() throws CoreException {
		project.delete(true, true, new NullProgressMonitor());
		MockLanguageSever.INSTANCE.shutdown();
	}

	@Test
	public void testOpen() throws Exception {
		IFile testFile = TestUtils.createUniqueTestFile(project, "");
		
		CompletableFuture<DidOpenTextDocumentParams> didOpenExpectation = new CompletableFuture<DidOpenTextDocumentParams>();
		MockLanguageSever.INSTANCE.setDidOpenCallback(didOpenExpectation);

		IEditorPart editor = TestUtils.openEditor(testFile);

		// Force LS to initialize and open file
		LanguageServiceAccessor.getInitializedLanguageServers(testFile, capabilites -> Boolean.TRUE);

		DidOpenTextDocumentParams lastOpen = didOpenExpectation.get(1000, TimeUnit.MILLISECONDS);
		assertNotNull(lastOpen.getTextDocument());
		assertEquals("lspt", lastOpen.getTextDocument().getLanguageId());

		((AbstractTextEditor)editor).close(false);
	}

	@Test
	public void testOpenWithSpecificLanguageId() throws Exception {
		IFile testFile = TestUtils.createUniqueTestFile(project, "lspt-different", "");
		
		CompletableFuture<DidOpenTextDocumentParams> didOpenExpectation = new CompletableFuture<DidOpenTextDocumentParams>();
		MockLanguageSever.INSTANCE.setDidOpenCallback(didOpenExpectation);

		IEditorPart editor = TestUtils.openEditor(testFile);

		// Force LS to initialize and open file
		LanguageServiceAccessor.getInitializedLanguageServers(testFile, capabilites -> Boolean.TRUE);

		DidOpenTextDocumentParams lastOpen = didOpenExpectation.get(1000, TimeUnit.MILLISECONDS);
		assertNotNull(lastOpen.getTextDocument());
		assertEquals("differentLanguageId", lastOpen.getTextDocument().getLanguageId());

		((AbstractTextEditor)editor).close(false);
	}

}
