/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.LSDisplayHelper;
import org.eclipse.lsp4e.test.MappingEnablementTester;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServerMultiRootFolders;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LanguageServiceAccessorTest {
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("LanguageServiceAccessorTest" + System.currentTimeMillis());
    }

    @After
    public void tearDown() throws CoreException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testGetLSPDocumentInfoForInvalidDocument() {
        List infos = LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)new Document(), null);
        Assert.assertTrue((boolean)infos.isEmpty());
    }

    @Test
    public void testGetLSPDocumentInfoForInvalidTextEditor() throws CoreException, InvocationTargetException {
        IFile testFile = TestUtils.createFile(this.project, "not_associated_with_ls.abc", "");
        ITextViewer textViewer = TestUtils.openTextViewer(testFile);
        List infos = LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)textViewer.getDocument(), capabilities -> Boolean.TRUE);
        Assert.assertTrue((boolean)infos.isEmpty());
    }

    @Test
    public void testGetLanguageServerInvalidFile() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "not_associated_with_ls.abc", "");
        ArrayList<LanguageServer> servers = new ArrayList<LanguageServer>();
        for (CompletableFuture future : LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilites -> Boolean.TRUE)) {
            servers.add((LanguageServer)future.get(1L, TimeUnit.SECONDS));
        }
        Assert.assertTrue((boolean)servers.isEmpty());
    }

    @Test
    public void testLSAsExtension() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "shouldUseExtension.lspt", "");
        LanguageServer info = (LanguageServer)((CompletableFuture)LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilites -> Boolean.TRUE).iterator().next()).get(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)info);
    }

    @Test
    public void testLSAsRunConfiguration() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "shouldUseRunConfiguration.lspt2", "");
        LanguageServer info = (LanguageServer)((CompletableFuture)LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilites -> Boolean.TRUE).iterator().next()).get(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)info);
    }

    @Test
    public void testLSAsExtensionForDifferentLanguageId() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "shouldUseExtension.lspt-different", "");
        @NonNull Collection lsWrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, capabilites -> Boolean.TRUE);
        Assert.assertEquals((long)1L, (long)lsWrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)lsWrappers.iterator().next();
        Assert.assertNotNull((Object)wrapper);
        IContentType contentType = Platform.getContentTypeManager().getContentType("org.eclipse.lsp4e.test.content-type-different");
        Assert.assertEquals((Object)"differentLanguageId", (Object)wrapper.getLanguageId(new IContentType[]{contentType}));
    }

    @Test
    public void testGetLSWrappersInitializationFailed() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "fileWithFailedServer.lsptWithException", "");
        Collection wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, capabilites -> Boolean.TRUE);
        Assert.assertThat((Object)wrappers.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testReuseSameLSforMultiContentType() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        IFile testFile2 = TestUtils.createUniqueTestFileMultiLS(this.project, "");
        ArrayList<LanguageServer> file1LanguageServers = new ArrayList<LanguageServer>();
        for (CompletableFuture future : LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile1, capabilites -> Boolean.TRUE)) {
            file1LanguageServers.add((LanguageServer)future.get(1L, TimeUnit.SECONDS));
        }
        Assert.assertEquals((long)1L, (long)file1LanguageServers.size());
        LanguageServer file1LS = (LanguageServer)file1LanguageServers.iterator().next();
        ArrayList<LanguageServer> file2LanguageServers = new ArrayList<LanguageServer>();
        for (CompletableFuture future : LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile2, capabilites -> Boolean.TRUE)) {
            file2LanguageServers.add((LanguageServer)future.get(1L, TimeUnit.SECONDS));
        }
        Assert.assertEquals((long)2L, (long)file2LanguageServers.size());
        Assert.assertTrue((boolean)file2LanguageServers.contains(file1LS));
        Assert.assertEquals((String)"Not right amount of language servers bound to project", (long)2L, (long)LanguageServiceAccessor.getLanguageServers((IProject)this.project, c -> Boolean.TRUE).size());
    }

    @Test
    public void testCreateNewLSAfterInitialProjectGotDeleted() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile1, capabilities -> Boolean.TRUE).iterator().next();
        new LSDisplayHelper(() -> MockLanguageSever.INSTANCE.isRunning()).waitForCondition(Display.getCurrent(), 5000L, 300L);
        Collection wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, c -> Boolean.TRUE);
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper1.isActive());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        new LSDisplayHelper(() -> !MockLanguageSever.INSTANCE.isRunning()).waitForCondition(Display.getCurrent(), 5000L, 300L);
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.project = TestUtils.createProject("LanguageServiceAccessorTest2" + System.currentTimeMillis());
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile2);
        LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile2, capabilities -> Boolean.TRUE).iterator().next();
        new LSDisplayHelper(() -> MockLanguageSever.INSTANCE.isRunning()).waitForCondition(Display.getCurrent(), 5000L, 300L);
        wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile2, c -> Boolean.TRUE);
        LanguageServerWrapper wrapper2 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper2.isActive());
        Assert.assertTrue((wrapper1 != wrapper2 ? 1 : 0) != 0);
    }

    @Test
    public void testReuseMultirootFolderLSAfterInitialProjectGotDeleted() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "lsptWithMultiRoot", "");
        TestUtils.openEditor(testFile1);
        LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile1, capabilities -> Boolean.TRUE).iterator().next();
        new LSDisplayHelper(() -> MockLanguageServerMultiRootFolders.INSTANCE.isRunning()).waitForCondition(Display.getCurrent(), 5000L, 300L);
        Collection wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, c -> Boolean.TRUE);
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper1.isActive());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        new LSDisplayHelper(() -> !MockLanguageServerMultiRootFolders.INSTANCE.isRunning()).waitForCondition(Display.getCurrent(), 5000L, 300L);
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.project = TestUtils.createProject("LanguageServiceAccessorTest2" + System.currentTimeMillis());
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "lsptWithMultiRoot", "");
        TestUtils.openEditor(testFile2);
        LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile2, capabilities -> Boolean.TRUE).iterator().next();
        new LSDisplayHelper(() -> MockLanguageServerMultiRootFolders.INSTANCE.isRunning()).waitForCondition(Display.getCurrent(), 5000L, 300L);
        wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile2, c -> Boolean.TRUE);
        LanguageServerWrapper wrapper2 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper2.isActive());
        Assert.assertTrue((wrapper1 == wrapper2 ? 1 : 0) != 0);
    }

    @Test
    public void testDontRestartUnrelatedLSForFileFromSameProject() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "lspt-different", "");
        Collection wrappers1 = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, c -> Boolean.TRUE);
        Assert.assertEquals((long)1L, (long)wrappers1.size());
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers1.iterator().next();
        Assert.assertTrue((boolean)wrapper1.isActive());
        wrapper1.disconnect(testFile1.getFullPath());
        Assert.assertFalse((boolean)wrapper1.isActive());
        Collection wrappers2 = LanguageServiceAccessor.getLSWrappers((IFile)testFile2, c -> Boolean.TRUE);
        Assert.assertEquals((long)1L, (long)wrappers2.size());
        LanguageServerWrapper wrapper2 = (LanguageServerWrapper)wrappers2.iterator().next();
        Assert.assertTrue((boolean)wrapper2.isActive());
        Assert.assertFalse((boolean)wrapper1.isActive());
        wrapper2.disconnect(testFile2.getFullPath());
    }

    @Test
    public void testLanguageServerHierarchy_moreSpecializedFirst() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lsptchild", "");
        @NonNull Collection servers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, c -> Boolean.TRUE);
        Iterator iterator = servers.iterator();
        Assert.assertEquals((Object)"org.eclipse.lsp4e.test.server2", (Object)((LanguageServerWrapper)iterator.next()).serverDefinition.id);
        Assert.assertEquals((Object)"org.eclipse.lsp4e.test.server", (Object)((LanguageServerWrapper)iterator.next()).serverDefinition.id);
    }

    @Test
    public void testLanguageServerHierarchy_parentContentTypeUsed() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lsptchildNoLS", "");
        @NonNull Collection servers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, c -> Boolean.TRUE);
        Iterator iterator = servers.iterator();
        Assert.assertEquals((Object)"org.eclipse.lsp4e.test.server", (Object)((LanguageServerWrapper)iterator.next()).serverDefinition.id);
        Assert.assertFalse((String)"Should only be a single LS", (boolean)iterator.hasNext());
    }

    @Test
    public void testLanguageServerEnablement() throws Exception {
        LanguageServerPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.lsp4e.test.server.disable/org.eclipse.lsp4e.test.content-type-disabled", "false");
        IFile disabledFile = TestUtils.createUniqueTestFile(this.project, "lspt-disabled", "");
        IFile enabledFile = TestUtils.createUniqueTestFile(this.project, "lspt-enabled", "");
        LanguageServiceAccessor.getLSWrappers((IFile)disabledFile, capabilities -> true).stream().forEach(wrapper -> Assert.assertFalse((boolean)wrapper.serverDefinition.id.equals("org.eclipse.lsp4e.test.server.disable")));
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLSWrappers((IFile)enabledFile, capabilities -> true).stream().filter(wrapper -> wrapper.serverDefinition.id.equals("org.eclipse.lsp4e.test.server.disable")).findFirst().isPresent());
        LanguageServerPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.lsp4e.test.server.disable/org.eclipse.lsp4e.test.content-type-disabled", "true");
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLSWrappers((IFile)disabledFile, capabilities -> true).stream().filter(wrapper -> wrapper.serverDefinition.id.equals("org.eclipse.lsp4e.test.server.disable")).findFirst().isPresent());
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLSWrappers((IFile)enabledFile, capabilities -> true).stream().filter(wrapper -> wrapper.serverDefinition.id.equals("org.eclipse.lsp4e.test.server.disable")).findFirst().isPresent());
    }

    @Test
    public void testLanguageServerEnablementTester() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "lspt-tester", "");
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLSWrappers((IFile)file, capabilities -> true).isEmpty());
        MappingEnablementTester.enabled = true;
        Collection wrappers = LanguageServiceAccessor.getLSWrappers((IFile)file, capabilities -> true);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        Assert.assertEquals((Object)"org.eclipse.lsp4e.test.server.disable", (Object)((LanguageServerWrapper)wrappers.iterator().next()).serverDefinition.id);
    }
}

