/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.LSDisplayHelper;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RunningLanguageServerTest {
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        MockLanguageSever.reset();
        this.project = TestUtils.createProject("StartStopServerTest" + System.currentTimeMillis());
    }

    @After
    public void tearDown() throws CoreException {
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        MockLanguageSever.INSTANCE.shutdown();
    }

    @Test
    public void testOpenCloseLanguageServer() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        Display display = Display.getCurrent();
        int i = 0;
        while (i < 10) {
            IEditorPart editor = TestUtils.openEditor(testFile);
            LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilities -> Boolean.TRUE).iterator().next();
            Assert.assertTrue((String)("language server is started for iteration #" + i), (boolean)new LSDisplayHelper(() -> MockLanguageSever.INSTANCE.isRunning()).waitForCondition(display, 5000L));
            ((AbstractTextEditor)editor).close(false);
            Assert.assertTrue((String)("language server is closed for iteration #" + i), (boolean)new LSDisplayHelper(() -> !MockLanguageSever.INSTANCE.isRunning()).waitForCondition(display, 5000L));
            ++i;
        }
    }

    @Test
    public void testDisabledLanguageServer() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lspt-disabled", "");
        Display display = Display.getCurrent();
        ContentTypeToLanguageServerDefinition lsDefinition = TestUtils.getDisabledLS();
        lsDefinition.setUserEnabled(false);
        LanguageServiceAccessor.disableLanguageServerContentType((ContentTypeToLanguageServerDefinition)lsDefinition);
        TestUtils.openEditor(testFile);
        List initializedLanguageServers = LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilities -> Boolean.TRUE);
        Assert.assertNotNull((Object)initializedLanguageServers);
        Assert.assertEquals((String)"language server should not be started because it is disabled", (long)0L, (long)initializedLanguageServers.size());
        lsDefinition.setUserEnabled(true);
        LanguageServiceAccessor.enableLanguageServerContentType((ContentTypeToLanguageServerDefinition)lsDefinition, (IEditorReference[])TestUtils.getEditors());
        Assert.assertTrue((String)"language server should be started", (boolean)new LSDisplayHelper(() -> MockLanguageSever.INSTANCE.isRunning()).waitForCondition(display, 5000L));
    }
}

