/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.Assert;

public class TestUtils {
    private TestUtils() {
    }

    public static ITextViewer openTextViewer(IFile file) throws InvocationTargetException, PartInitException {
        IEditorPart editor = TestUtils.openEditor(file);
        return TestUtils.getTextViewer(editor);
    }

    public static ITextViewer getTextViewer(IEditorPart part) throws InvocationTargetException {
        try {
            if (part instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)part;
                Method getSourceViewerMethod = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
                getSourceViewerMethod.setAccessible(true);
                return (ITextViewer)getSourceViewerMethod.invoke((Object)textEditor, new Object[0]);
            }
            Assert.fail((String)"Unable to open editor");
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InvocationTargetException(e);
        }
    }

    public static IEditorPart openEditor(IFile file) throws PartInitException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        FileEditorInput input = new FileEditorInput(file);
        IEditorPart part = page.openEditor((IEditorInput)input, "org.eclipse.ui.genericeditor.GenericEditor", false);
        part.setFocus();
        return part;
    }

    public static boolean closeEditor(IEditorPart editor, boolean save) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        return page.closeEditor(editor, save);
    }

    public static IProject createProject(String projectName) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            return project;
        }
        project.create(null);
        project.open(null);
        return project;
    }

    public static IFile createUniqueTestFile(IProject p, String content) throws CoreException {
        return TestUtils.createUniqueTestFile(p, "lspt", content);
    }

    public static IFile createUniqueTestFileMultiLS(IProject p, String content) throws CoreException {
        return TestUtils.createUniqueTestFile(p, "lsptmultils", content);
    }

    public static IFile createUniqueTestFileOfUnknownType(IProject p, String content) throws CoreException {
        return TestUtils.createUniqueTestFile(p, "lsptunknown", content);
    }

    public static IFile createUniqueTestFile(IProject p, String extension, String content) throws CoreException {
        return TestUtils.createFile(p, "test" + System.currentTimeMillis() + '.' + extension, content);
    }

    public static IFile createFile(IProject p, String name, String content) throws CoreException {
        IFile testFile = p.getFile(name);
        testFile.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
        return testFile;
    }

    public static ContentTypeToLanguageServerDefinition getDisabledLS() {
        return LanguageServersRegistry.getInstance().getContentTypeToLSPExtensions().stream().filter(definition -> "org.eclipse.lsp4e.test.server.disable".equals(((LanguageServersRegistry.LanguageServerDefinition)definition.getValue()).id) && "org.eclipse.lsp4e.test.content-type-disabled".equals(((IContentType)definition.getKey()).toString())).findFirst().get();
    }

    public static IEditorReference[] getEditors() {
        IWorkbenchPage wPage;
        IWorkbenchWindow wWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wWindow != null && (wPage = wWindow.getActivePage()) != null) {
            return wPage.getEditorReferences();
        }
        return null;
    }
}

