/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.codeactions;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.test.NoErrorLoggedRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CodeActionTests {
    @Rule
    public NoErrorLoggedRule rule = new NoErrorLoggedRule(LanguageServerPlugin.getDefault().getLog());

    @Before
    public void setUp() throws CoreException {
        MockLanguageSever.reset();
    }

    @Test
    public void testCodeActions() throws CoreException {
        IProject p = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        final IFile f = TestUtils.createUniqueTestFile(p, "error");
        MockLanguageSever.INSTANCE.setCodeActions(Collections.singletonList(new Command("fixme", "edit", Collections.singletonList(new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed")))));
        MockLanguageSever.INSTANCE.setDiagnostics(Collections.singletonList(new Diagnostic(new Range(new Position(0, 0), new Position(0, 5)), "error", DiagnosticSeverity.Error, null)));
        final AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        try {
            new DisplayHelper(){

                protected boolean condition() {
                    try {
                        return f.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length > 0;
                    }
                    catch (CoreException e) {
                        return false;
                    }
                }
            }.waitForCondition(Display.getCurrent(), 2000L);
            final IMarker m = f.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0)[0];
            Assert.assertEquals((Object)"error", (Object)m.getAttribute("message"));
            new DisplayHelper(){

                protected boolean condition() {
                    return IDE.getMarkerHelpRegistry().hasResolutions(m) && IDE.getMarkerHelpRegistry().getResolutions(m)[0].getLabel().equals("fixme");
                }
            }.waitForCondition(Display.getCurrent(), 2000L);
            IDE.getMarkerHelpRegistry().getResolutions(m)[0].run(m);
            new DisplayHelper(){

                protected boolean condition() {
                    return "fixed".equals(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
                }
            }.waitForCondition(Display.getCurrent(), 1000L);
            Assert.assertEquals((Object)"fixed", (Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
            new DisplayHelper(){

                protected boolean condition() {
                    return "fixed".equals(((StyledText)editor.getAdapter(Control.class)).getText());
                }
            }.waitForCondition(Display.getCurrent(), 1000L);
            Assert.assertEquals((Object)"fixed", (Object)((StyledText)editor.getAdapter(Control.class)).getText());
        }
        finally {
            editor.close(false);
            p.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

