/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.commands;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.Unregistration;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DynamicRegistrationTest {
    private static final String WORKSPACE_EXECUTE_COMMAND = "workspace/executeCommand";
    private static final String WORKSPACE_DID_CHANGE_FOLDERS = "workspace/didChangeWorkspaceFolders";
    private IProject project;

    @Before
    public void setUp() throws Exception {
        MockLanguageSever.reset();
        LanguageServiceAccessor.clearStartedServers();
        this.project = TestUtils.createProject("CommandRegistrationTest" + System.currentTimeMillis());
        IFile testFile = TestUtils.createFile(this.project, "shouldUseExtension.lspt", "");
        LanguageServer info = (LanguageServer)((CompletableFuture)LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilites -> Boolean.TRUE).iterator().next()).get(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)info);
    }

    @After
    public void tearDown() throws CoreException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testCommandRegistration() throws Exception {
        @NonNull @NonNull List servers = LanguageServiceAccessor.getLanguageServers(c -> true);
        Assert.assertEquals((long)1L, (long)servers.size());
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLanguageServers(this.handlesCommand("test.command")).isEmpty());
        UUID registration = this.registerCommands("test.command", "test.command.2");
        try {
            Assert.assertEquals((long)1L, (long)LanguageServiceAccessor.getLanguageServers(this.handlesCommand("test.command")).size());
            Assert.assertEquals((long)1L, (long)LanguageServiceAccessor.getLanguageServers(this.handlesCommand("test.command.2")).size());
        }
        finally {
            this.unregister(registration);
        }
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLanguageServers(this.handlesCommand("test.command")).isEmpty());
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLanguageServers(this.handlesCommand("test.command.2")).isEmpty());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testWorkspaceFoldersRegistration() throws Exception {
        @NonNull @NonNull List servers = LanguageServiceAccessor.getLanguageServers(c -> true);
        Assert.assertEquals((long)1L, (long)servers.size());
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLanguageServers(c -> this.hasWorkspaceFolderSupport((ServerCapabilities)c)).isEmpty());
        UUID registration = this.registerWorkspaceFolders();
        try {
            Assert.assertEquals((long)1L, (long)LanguageServiceAccessor.getLanguageServers(c -> this.hasWorkspaceFolderSupport((ServerCapabilities)c)).size());
        }
        finally {
            this.unregister(registration);
        }
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLanguageServers(c -> this.hasWorkspaceFolderSupport((ServerCapabilities)c)).isEmpty());
        Assert.assertEquals((long)1L, (long)LanguageServiceAccessor.getLanguageServers(c -> !this.hasWorkspaceFolderSupport((ServerCapabilities)c)).size());
    }

    private void unregister(UUID registration) throws Exception {
        LanguageClient client = this.getMockClient();
        Unregistration unregistration = new Unregistration(registration.toString(), WORKSPACE_EXECUTE_COMMAND);
        client.unregisterCapability(new UnregistrationParams(Arrays.asList(unregistration))).get(1L, TimeUnit.SECONDS);
    }

    private UUID registerWorkspaceFolders() throws Exception {
        UUID id = UUID.randomUUID();
        LanguageClient client = this.getMockClient();
        Registration registration = new Registration();
        registration.setId(id.toString());
        registration.setMethod(WORKSPACE_DID_CHANGE_FOLDERS);
        client.registerCapability(new RegistrationParams(Arrays.asList(registration))).get(1L, TimeUnit.SECONDS);
        return id;
    }

    private UUID registerCommands(String ... command) throws Exception {
        UUID id = UUID.randomUUID();
        LanguageClient client = this.getMockClient();
        Registration registration = new Registration();
        registration.setId(id.toString());
        registration.setMethod(WORKSPACE_EXECUTE_COMMAND);
        registration.setRegisterOptions((Object)new Gson().toJsonTree((Object)new ExecuteCommandOptions(Arrays.asList(command))));
        client.registerCapability(new RegistrationParams(Arrays.asList(registration))).get(1L, TimeUnit.SECONDS);
        return id;
    }

    private LanguageClient getMockClient() {
        List proxies = MockLanguageSever.INSTANCE.getRemoteProxies();
        Assert.assertEquals((long)1L, (long)proxies.size());
        return (LanguageClient)proxies.get(0);
    }

    private Predicate<ServerCapabilities> handlesCommand(String command) {
        return cap -> {
            ExecuteCommandOptions commandProvider = cap.getExecuteCommandProvider();
            return commandProvider != null && commandProvider.getCommands().contains(command);
        };
    }

    private boolean hasWorkspaceFolderSupport(ServerCapabilities cap) {
        WorkspaceFoldersOptions f;
        WorkspaceServerCapabilities ws;
        if (cap != null && (ws = cap.getWorkspace()) != null && (f = ws.getWorkspaceFolders()) != null) {
            return f.getSupported();
        }
        return false;
    }
}

