/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ProjectSpecificLanguageServerWrapper;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompleteCompletionTest {
    private IProject project;
    private LSContentAssistProcessor contentAssistProcessor;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("CompletionTest" + System.currentTimeMillis());
        this.contentAssistProcessor = new LSContentAssistProcessor();
    }

    @After
    public void tearDown() throws CoreException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        MockLanguageSever.INSTANCE.shutdown();
    }

    @Test
    public void testAssistForUnknownButConnectedType() throws CoreException, InvocationTargetException, IOException, InterruptedException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, items));
        IFile testFile = TestUtils.createUniqueTestFileOfUnknownType(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        LanguageServersRegistry.LanguageServerDefinition serverDefinition = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.lsp4e.test.server");
        Assert.assertNotNull((Object)serverDefinition);
        final ProjectSpecificLanguageServerWrapper lsWrapperForConnection = LanguageServiceAccessor.getLSWrapperForConnection((IProject)testFile.getProject(), (LanguageServersRegistry.LanguageServerDefinition)serverDefinition);
        final IPath fileLocation = testFile.getLocation();
        lsWrapperForConnection.connect(fileLocation, null);
        new DisplayHelper(){

            protected boolean condition() {
                return lsWrapperForConnection.isConnectedTo(fileLocation);
            }
        }.waitForCondition(Display.getCurrent(), 3000L);
        Assert.assertTrue((boolean)lsWrapperForConnection.isConnectedTo(fileLocation));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)items.size(), (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testNoPrefix() throws CoreException, InvocationTargetException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, items));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)items.size(), (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testPrefix() throws CoreException, InvocationTargetException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        items.add(this.createCompletionItem("SecondClass", CompletionItemKind.Class));
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "First";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testPrefixCaseSensitivity() throws CoreException, InvocationTargetException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "FIRST";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompleteOnFileEnd() throws CoreException, InvocationTargetException {
        CompletionItem item = new CompletionItem();
        item.setLabel("1024M");
        item.setKind(CompletionItemKind.Value);
        item.setTextEdit(new TextEdit(new Range(new Position(2, 10), new Position(2, 10)), "1024M"));
        CompletionList completionList = new CompletionList(false, Collections.singletonList(item));
        MockLanguageSever.INSTANCE.setCompletionList(completionList);
        String content = "applications:\n- name: hello\n  memory: ";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, content.length());
        Assert.assertEquals((Object)(String.valueOf(content) + "1024M"), (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testTriggerCharsWithoutPreliminaryCompletion() throws CoreException, InvocationTargetException {
        HashSet<String> triggers = new HashSet<String>();
        triggers.add("a");
        triggers.add("b");
        MockLanguageSever.INSTANCE.setCompletionTriggerChars(triggers);
        String content = "First";
        TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        Assert.assertArrayEquals((char[])new char[]{'a', 'b'}, (char[])this.contentAssistProcessor.getCompletionProposalAutoActivationCharacters());
    }

    @Test
    public void testTriggerCharsNullList() throws CoreException, InvocationTargetException {
        MockLanguageSever.INSTANCE.setCompletionTriggerChars(null);
        TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "First"));
        Assert.assertArrayEquals((char[])new char[0], (char[])this.contentAssistProcessor.getCompletionProposalAutoActivationCharacters());
    }

    @Test
    public void testApplyCompletionWithPrefix() throws CoreException, InvocationTargetException {
        Range range = new Range(new Position(0, 0), new Position(0, 5));
        List<CompletionItem> items = Collections.singletonList(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "First";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, content.length());
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, content.length());
        Assert.assertEquals((Object)true, (Object)viewer.getDocument().get().equals("FirstClass"));
        Assert.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplace() throws CoreException, InvocationTargetException {
        Range range = new Range(new Position(0, 0), new Position(0, 20));
        List<CompletionItem> items = Collections.singletonList(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "FirstNotMatchedLabel";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 5);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 5);
        Assert.assertEquals((Object)"FirstClass", (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplaceAndTypingWithTextEdit() throws CoreException, InvocationTargetException, BadLocationException {
        Range range = new Range(new Position(0, 0), new Position(0, 20));
        List<CompletionItem> items = Collections.singletonList(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "FirstNotMatchedLabel";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        int invokeOffset = 5;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        viewer.getDocument().replace(5, 0, "No");
        lsCompletionProposal.apply(viewer, '\n', 0, invokeOffset + "No".length());
        Assert.assertEquals((Object)"FirstClass", (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplaceAndTyping() throws CoreException, InvocationTargetException, BadLocationException {
        CompletionItem item = new CompletionItem("strncasecmp");
        item.setKind(CompletionItemKind.Function);
        item.setInsertText("strncasecmp()");
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, Collections.singletonList(item)));
        String content = "str";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        int invokeOffset = content.length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        viewer.getDocument().replace(content.length(), 0, "nc");
        lsCompletionProposal.apply(viewer, '\u0000', 0, invokeOffset + "nc".length());
        Assert.assertEquals((Object)item.getInsertText(), (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point(item.getInsertText().length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompletionReplace() throws CoreException, InvocationTargetException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "line1\nlineInsertHere");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, Collections.singletonList(this.createCompletionItem("Inserted", CompletionItemKind.Text, new Range(new Position(1, 4), new Position(1, 4 + "InsertHere".length()))))));
        int invokeOffset = viewer.getDocument().getLength() - "InsertHere".length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)"line1\nlineInserted", (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    private CompletionItem createCompletionItem(String label, CompletionItemKind kind) {
        return this.createCompletionItem(label, kind, new Range(new Position(0, 0), new Position(0, label.length())));
    }

    private CompletionItem createCompletionItem(String label, CompletionItemKind kind, Range range) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        item.setKind(kind);
        item.setTextEdit(new TextEdit(range, label));
        return item;
    }

    @Test
    public void testItemOrdering() throws Exception {
        Range range = new Range(new Position(0, 0), new Position(0, 1));
        List<CompletionItem> items = Arrays.asList(this.createCompletionItem("AA", CompletionItemKind.Class, range), this.createCompletionItem("AB", CompletionItemKind.Class, range), this.createCompletionItem("BA", CompletionItemKind.Class, range), this.createCompletionItem("BB", CompletionItemKind.Class, range), this.createCompletionItem("CB", CompletionItemKind.Class, range), this.createCompletionItem("CC", CompletionItemKind.Class, range));
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "B";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        int invokeOffset = 1;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)4L, (long)proposals.length);
        Assert.assertEquals((Object)"BA", (Object)proposals[0].getDisplayString());
        Assert.assertEquals((Object)"BB", (Object)proposals[1].getDisplayString());
        Assert.assertEquals((Object)"AB", (Object)proposals[2].getDisplayString());
        Assert.assertEquals((Object)"CB", (Object)proposals[3].getDisplayString());
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)"BA", (Object)viewer.getDocument().get());
    }

    @Test
    public void testBasicSnippet() throws PartInitException, InvocationTargetException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("$1 and ${2:foo}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, Collections.singletonList(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)" and foo", (Object)viewer.getDocument().get());
    }

    @Test
    public void testDuplicateVariable() throws PartInitException, InvocationTargetException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("${1:foo} and ${1:foo}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, Collections.singletonList(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)"foo and foo", (Object)viewer.getDocument().get());
    }

    @Test
    public void testSnippetTabStops() throws PartInitException, InvocationTargetException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("sum(${1:x}, ${2:y})", CompletionItemKind.Method, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, Collections.singletonList(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assert.assertEquals((long)1L, (long)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)"sum(x, y)", (Object)viewer.getDocument().get());
        Point range = proposals[0].getSelection(viewer.getDocument());
        Assert.assertEquals((long)4L, (long)range.x);
        Assert.assertEquals((long)1L, (long)range.y);
        Event event = new Event();
        event.character = (char)9;
        viewer.getTextWidget().notifyListeners(3005, event);
        range = viewer.getSelectedRange();
        Assert.assertEquals((long)7L, (long)range.x);
        Assert.assertEquals((long)1L, (long)range.y);
    }

    @Test
    public void testMultipleLS() throws Exception {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, items));
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)(2 * items.size()), (long)proposals.length);
    }

    @Test
    public void testReopeningFileAndReusingContentAssist() throws CoreException, InvocationTargetException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, items));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)items.size(), (long)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        MockLanguageSever.INSTANCE.shutdown();
        MockLanguageSever.INSTANCE.setCompletionList(new CompletionList(false, items));
        viewer = TestUtils.openTextViewer(testFile);
        proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)items.size(), (long)proposals.length);
        lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assert.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }
}

