/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.definition;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.operations.declaration.OpenDeclarationHyperlinkDetector;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefinitionTest {
    private IProject project;
    private OpenDeclarationHyperlinkDetector hyperlinkDetector;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("DefinitionTest" + System.currentTimeMillis());
        this.hyperlinkDetector = new OpenDeclarationHyperlinkDetector();
    }

    @After
    public void tearDown() throws CoreException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        MockLanguageSever.INSTANCE.shutdown();
    }

    @Test
    public void testDefinitionOneLocation() throws Exception {
        Location location = new Location("file://test", new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageSever.INSTANCE.setDefinition(Collections.singletonList(location));
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.hyperlinkDetector.detectHyperlinks(viewer, (IRegion)new Region(1, 0), true);
        Assert.assertEquals((long)1L, (long)hyperlinks.length);
    }

    @Test
    public void testDefinitionManyLocation() throws Exception {
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(new Location("file://test0", new Range(new Position(0, 0), new Position(0, 10))));
        locations.add(new Location("file://test1", new Range(new Position(1, 0), new Position(1, 10))));
        locations.add(new Location("file://test2", new Range(new Position(2, 0), new Position(2, 10))));
        MockLanguageSever.INSTANCE.setDefinition(locations);
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.hyperlinkDetector.detectHyperlinks(viewer, (IRegion)new Region(1, 0), true);
        Assert.assertEquals((long)3L, (long)hyperlinks.length);
    }

    @Test
    public void testDefinitionNoLocations() throws Exception {
        MockLanguageSever.INSTANCE.setDefinition(null);
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.hyperlinkDetector.detectHyperlinks(viewer, (IRegion)new Region(1, 0), true);
        Assert.assertEquals((Object)true, (Object)(hyperlinks == null ? 1 : 0));
    }

    @Test
    public void testDefinitionEmptyLocations() throws Exception {
        MockLanguageSever.INSTANCE.setDefinition(Collections.emptyList());
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.hyperlinkDetector.detectHyperlinks(viewer, (IRegion)new Region(1, 0), true);
        Assert.assertEquals((Object)true, (Object)(hyperlinks == null ? 1 : 0));
    }
}

