/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.diagnostics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.lsp4e.operations.diagnostics.LSPDiagnosticsToMarkers;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DiagnosticsTest {
    private IProject project;
    private LSPDiagnosticsToMarkers diagnosticsToMarkers;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("DiagnoticsTest" + System.currentTimeMillis());
        this.diagnosticsToMarkers = new LSPDiagnosticsToMarkers(this.project, "dummy");
    }

    @After
    public void tearDown() throws CoreException {
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        MockLanguageSever.INSTANCE.shutdown();
    }

    @Test
    public void testDiagnostics() throws CoreException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Diagnostic Other Text");
        Range range = new Range(new Position(0, 0), new Position(0, 10));
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        diagnostics.add(this.createDiagnostic("1", "message1", range, DiagnosticSeverity.Error, "source1"));
        diagnostics.add(this.createDiagnostic("2", "message2", range, DiagnosticSeverity.Warning, "source2"));
        diagnostics.add(this.createDiagnostic("3", "message3", range, DiagnosticSeverity.Information, "source3"));
        diagnostics.add(this.createDiagnostic("4", "message4", range, DiagnosticSeverity.Hint, "source4"));
        this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(file.getLocationURI().toString(), diagnostics));
        IMarker[] markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2);
        Assert.assertEquals((long)diagnostics.size(), (long)markers.length);
        int i = 0;
        while (i < diagnostics.size()) {
            Diagnostic diagnostic = (Diagnostic)diagnostics.get(i);
            IMarker marker = markers[i];
            Assert.assertEquals((Object)diagnostic.getMessage(), (Object)MarkerUtilities.getMessage((IMarker)marker));
            Assert.assertEquals((long)0L, (long)MarkerUtilities.getCharStart((IMarker)marker));
            Assert.assertEquals((long)10L, (long)MarkerUtilities.getCharEnd((IMarker)marker));
            Assert.assertEquals((long)1L, (long)MarkerUtilities.getLineNumber((IMarker)marker));
            ++i;
        }
        this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(file.getLocationURI().toString(), Collections.emptyList()));
        markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2);
        Assert.assertEquals((long)0L, (long)markers.length);
    }

    @Test
    public void testDiagnosticsRangeAfterDocument() throws CoreException {
        String content = "Diagnostic Other Text";
        IFile file = TestUtils.createUniqueTestFile(this.project, content);
        Range range = new Range(new Position(1, 0), new Position(1, 5));
        List<Diagnostic> diagnostics = Collections.singletonList(this.createDiagnostic("1", "message1", range, DiagnosticSeverity.Error, "source1"));
        this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(file.getLocationURI().toString(), diagnostics));
        IMarker[] markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2);
        Assert.assertEquals((long)diagnostics.size(), (long)markers.length);
        int i = 0;
        while (i < diagnostics.size()) {
            Diagnostic diagnostic = diagnostics.get(i);
            IMarker marker = markers[i];
            Assert.assertEquals((Object)diagnostic.getMessage(), (Object)MarkerUtilities.getMessage((IMarker)marker));
            Assert.assertEquals((long)content.length(), (long)MarkerUtilities.getCharStart((IMarker)marker));
            Assert.assertEquals((long)content.length(), (long)MarkerUtilities.getCharEnd((IMarker)marker));
            Assert.assertEquals((long)1L, (long)MarkerUtilities.getLineNumber((IMarker)marker));
            ++i;
        }
    }

    @Test
    public void testDiagnosticsFromVariousLS() throws Exception {
        String content = "Diagnostic Other Text";
        IFile file = TestUtils.createUniqueTestFileMultiLS(this.project, content);
        Range range = new Range(new Position(1, 0), new Position(1, 0));
        MockLanguageSever.INSTANCE.setDiagnostics(Collections.singletonList(this.createDiagnostic("1", "message1", range, DiagnosticSeverity.Error, "source1")));
        IMarker[] markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
        Assert.assertEquals((String)"no marker should be shown at file initialization", (long)0L, (long)markers.length);
        TestUtils.openEditor(file);
        Thread.sleep(300L);
        markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
        Assert.assertEquals((String)"there should be 1 marker for each language server", (long)2L, (long)markers.length);
    }

    private Diagnostic createDiagnostic(String code, String message, Range range, DiagnosticSeverity severity, String source) {
        Diagnostic diagnostic = new Diagnostic();
        diagnostic.setCode(code);
        diagnostic.setMessage(message);
        diagnostic.setRange(range);
        diagnostic.setSeverity(severity);
        diagnostic.setSource(source);
        return diagnostic;
    }
}

