/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.document;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.test.NoErrorLoggedRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;

public class LSPEclipseUtilsTest {
    @Rule
    public NoErrorLoggedRule rule = new NoErrorLoggedRule(LanguageServerPlugin.getDefault().getLog());

    @Test
    public void testOpenInEditorExternalFile() throws Exception {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        File externalFile = File.createTempFile("externalFile", ".txt");
        try {
            Location location = new Location(LSPEclipseUtils.toUri((File)externalFile).toString(), new Range(new Position(0, 0), new Position(0, 0)));
            LSPEclipseUtils.openInEditor((Location)location, (IWorkbenchPage)page);
        }
        finally {
            page.closeEditor(page.getActiveEditor(), false);
            externalFile.delete();
        }
    }

    @Test
    public void testWorkspaceEdit() throws Exception {
        IProject p = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile f = TestUtils.createFile(p, "dummy", "Here");
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        try {
            WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonMap(LSPEclipseUtils.toUri((IResource)f).toString(), Collections.singletonList(new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "insert"))));
            LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)workspaceEdit);
            Assert.assertEquals((Object)"insertHere", (Object)((StyledText)editor.getAdapter(Control.class)).getText());
            Assert.assertEquals((Object)"insertHere", (Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
        }
        finally {
            editor.close(false);
            p.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Test
    public void testWorkspaceEditMultipleChanges() throws Exception {
        IProject p = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile f = TestUtils.createFile(p, "dummy", "Here\nHere2");
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        try {
            LinkedList<TextEdit> edits = new LinkedList<TextEdit>();
            edits.add(new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "abc"));
            edits.add(new TextEdit(new Range(new Position(1, 0), new Position(1, 0)), "abc"));
            WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonMap(LSPEclipseUtils.toUri((IResource)f).toString(), edits));
            LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)workspaceEdit);
            Assert.assertEquals((Object)"abcHere\nabcHere2", (Object)((StyledText)editor.getAdapter(Control.class)).getText());
            Assert.assertEquals((Object)"abcHere\nabcHere2", (Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
        }
        finally {
            editor.close(false);
            p.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Test
    public void testURIToResourceMapping() throws CoreException {
        IProject project1 = null;
        IProject project2 = null;
        try {
            project1 = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
            IFile file = project1.getFile("res");
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals((Object)file, (Object)LSPEclipseUtils.findResourceFor((String)file.getLocationURI().toString()));
            project1.getFile("suffix").create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            project2 = TestUtils.createProject(String.valueOf(project1.getName()) + "suffix");
            Assert.assertEquals((Object)project2, (Object)LSPEclipseUtils.findResourceFor((String)project2.getLocationURI().toString()));
        }
        finally {
            if (project1 != null) {
                project1.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            if (project2 != null) {
                project2.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    @Test
    public void testApplyTextEditLongerThanOrigin() throws Exception {
        IProject project = null;
        IEditorPart editor = null;
        try {
            project = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
            IFile file = TestUtils.createUniqueTestFile(project, "line1\nlineInsertHere");
            editor = TestUtils.openEditor(file);
            ITextViewer viewer = TestUtils.getTextViewer(editor);
            TextEdit textEdit = new TextEdit(new Range(new Position(1, 4), new Position(1, 4 + "InsertHere".length())), "Inserted");
            IDocument document = viewer.getDocument();
            LSPEclipseUtils.applyEdit((TextEdit)textEdit, (IDocument)document);
            Assert.assertEquals((Object)"line1\nlineInserted", (Object)document.get());
        }
        catch (Throwable throwable) {
            TestUtils.closeEditor(editor, false);
            if (project != null) {
                project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            throw throwable;
        }
        TestUtils.closeEditor(editor, false);
        if (project != null) {
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Test
    public void testApplyTextEditShorterThanOrigin() throws Exception {
        IProject project = null;
        IEditorPart editor = null;
        try {
            project = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
            IFile file = TestUtils.createUniqueTestFile(project, "line1\nlineHERE");
            editor = TestUtils.openEditor(file);
            ITextViewer viewer = TestUtils.getTextViewer(editor);
            TextEdit textEdit = new TextEdit(new Range(new Position(1, 4), new Position(1, 4 + "HERE".length())), "Inserted");
            IDocument document = viewer.getDocument();
            LSPEclipseUtils.applyEdit((TextEdit)textEdit, (IDocument)document);
            Assert.assertEquals((Object)"line1\nlineInserted", (Object)document.get());
        }
        catch (Throwable throwable) {
            TestUtils.closeEditor(editor, false);
            if (project != null) {
                project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            throw throwable;
        }
        TestUtils.closeEditor(editor, false);
        if (project != null) {
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Test
    public void testURICreationUnix() {
        Assume.assumeFalse((boolean)"win32".equals(Platform.getOS()));
        Assert.assertEquals((Object)"file:///test%20with%20space", (Object)LSPEclipseUtils.toUri((File)new File("/test with space")).toString());
    }
}

