/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.documentLink;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.operations.documentLink.DocumentLinkDetector;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DocumentLinkTest {
    private IProject project;
    private DocumentLinkDetector documentLinkDetector;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("DocumentLinkTest" + System.currentTimeMillis());
        this.documentLinkDetector = new DocumentLinkDetector();
    }

    @After
    public void tearDown() throws CoreException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        MockLanguageSever.INSTANCE.shutdown();
    }

    @Test
    public void testDocumentLinkNoResults() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Object[] hyperlinks = this.documentLinkDetector.detectHyperlinks(viewer, (IRegion)new Region(0, 0), true);
        Assert.assertArrayEquals(null, (Object[])hyperlinks);
    }

    @Test
    public void testDocumentLink() throws Exception {
        ArrayList<DocumentLink> links = new ArrayList<DocumentLink>();
        links.add(new DocumentLink(new Range(new Position(0, 9), new Position(0, 15)), "file://test0"));
        MockLanguageSever.INSTANCE.setDocumentLinks(links);
        IFile file = TestUtils.createUniqueTestFile(this.project, "not_link <link>");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.documentLinkDetector.detectHyperlinks(viewer, (IRegion)new Region(13, 0), true);
        Assert.assertEquals((long)1L, (long)hyperlinks.length);
        Assert.assertEquals((Object)"file://test0", (Object)hyperlinks[0].getHyperlinkText());
    }

    @Test
    public void testDocumentLinkWrongRegion() throws Exception {
        ArrayList<DocumentLink> links = new ArrayList<DocumentLink>();
        links.add(new DocumentLink(new Range(new Position(0, 9), new Position(0, 15)), "file://test0"));
        MockLanguageSever.INSTANCE.setDocumentLinks(links);
        IFile file = TestUtils.createUniqueTestFile(this.project, "not_link <link>");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Object[] hyperlinks = this.documentLinkDetector.detectHyperlinks(viewer, (IRegion)new Region(0, 0), true);
        Assert.assertArrayEquals(null, (Object[])hyperlinks);
    }
}

