/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;
import org.junit.Test;

public class DocumentDidCloseTest {
    @Test
    public void testClose() throws Exception {
        IProject project = TestUtils.createProject("DocumentDidCloseTest" + System.currentTimeMillis());
        IFile testFile = TestUtils.createUniqueTestFile(project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilites -> Boolean.TRUE);
        CompletableFuture didCloseExpectation = new CompletableFuture();
        MockLanguageSever.INSTANCE.setDidCloseCallback(didCloseExpectation);
        TestUtils.closeEditor(editor, false);
        DidCloseTextDocumentParams lastChange = (DidCloseTextDocumentParams)didCloseExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastChange.getTextDocument());
        Assert.assertEquals((Object)LSPEclipseUtils.toUri((IResource)testFile).toString(), (Object)lastChange.getTextDocument().getUri());
        project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        MockLanguageSever.INSTANCE.shutdown();
    }
}

