/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DocumentDidOpenTest {
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject(String.valueOf(this.getClass().getName()) + System.currentTimeMillis());
    }

    @After
    public void tearDown() throws CoreException {
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        MockLanguageSever.INSTANCE.shutdown();
    }

    @Test
    public void testOpen() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        CompletableFuture didOpenExpectation = new CompletableFuture();
        MockLanguageSever.INSTANCE.setDidOpenCallback(didOpenExpectation);
        IEditorPart editor = TestUtils.openEditor(testFile);
        LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilites -> Boolean.TRUE);
        DidOpenTextDocumentParams lastOpen = (DidOpenTextDocumentParams)didOpenExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastOpen.getTextDocument());
        Assert.assertEquals((Object)"lspt", (Object)lastOpen.getTextDocument().getLanguageId());
        ((AbstractTextEditor)editor).close(false);
    }

    @Test
    public void testOpenWithSpecificLanguageId() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lspt-different", "");
        CompletableFuture didOpenExpectation = new CompletableFuture();
        MockLanguageSever.INSTANCE.setDidOpenCallback(didOpenExpectation);
        IEditorPart editor = TestUtils.openEditor(testFile);
        LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilites -> Boolean.TRUE);
        DidOpenTextDocumentParams lastOpen = (DidOpenTextDocumentParams)didOpenExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastOpen.getTextDocument());
        Assert.assertEquals((Object)"differentLanguageId", (Object)lastOpen.getTextDocument().getLanguageId());
        ((AbstractTextEditor)editor).close(false);
    }
}

