/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.LSDisplayHelper;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DocumentDidSaveTest {
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject(String.valueOf(this.getClass().getName()) + System.currentTimeMillis());
    }

    @After
    public void tearDown() throws CoreException {
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        MockLanguageSever.INSTANCE.shutdown();
    }

    @Test
    public void testSave() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        testFile.setLocalTimeStamp(0L);
        LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilites -> Boolean.TRUE);
        CompletableFuture didSaveExpectation = new CompletableFuture();
        MockLanguageSever.INSTANCE.setDidSaveCallback(didSaveExpectation);
        viewer.getDocument().replace(0, 0, "Hello");
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        new LSDisplayHelper(() -> {
            try {
                DidSaveTextDocumentParams lastChange = (DidSaveTextDocumentParams)didSaveExpectation.get(10L, TimeUnit.MILLISECONDS);
                Assert.assertNotNull((Object)lastChange.getTextDocument());
                Assert.assertEquals((Object)LSPEclipseUtils.toUri((IResource)testFile).toString(), (Object)lastChange.getTextDocument().getUri());
                return true;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                return false;
            }
        }).waitForCondition(Display.getCurrent(), 2000L);
        ((AbstractTextEditor)editor).close(false);
    }
}

