/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DocumentRevertAndCloseTest {
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        MockLanguageSever.reset();
        this.project = TestUtils.createProject(String.valueOf(this.getClass().getName()) + System.currentTimeMillis());
    }

    @After
    public void tearDown() throws CoreException {
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        MockLanguageSever.INSTANCE.shutdown();
    }

    @Test
    public void testShutdownLsp() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "Hello!");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        testFile.setLocalTimeStamp(0L);
        LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilites -> Boolean.TRUE);
        viewer.getDocument().replace(0, 0, "Bye!");
        ((AbstractTextEditor)editor).doRevertToSaved();
        ((AbstractTextEditor)editor).getSite().getPage().closeEditor(editor, false);
        Display display = PlatformUI.getWorkbench().getDisplay();
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return !MockLanguageSever.INSTANCE.isRunning();
            }
        }.waitForCondition(display, 3000L));
    }
}

