/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.highlight;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class HighlightTest {
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("HighlightTest" + System.currentTimeMillis());
    }

    @After
    public void tearDown() throws CoreException {
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        MockLanguageSever.INSTANCE.shutdown();
    }

    @Test
    public void testHighlight() throws CoreException, InvocationTargetException {
        Annotation annotation;
        this.checkGenericEditorVersion();
        ArrayList<DocumentHighlight> highlights = new ArrayList<DocumentHighlight>();
        highlights.add(new DocumentHighlight(new Range(new Position(0, 2), new Position(0, 6)), DocumentHighlightKind.Read));
        highlights.add(new DocumentHighlight(new Range(new Position(0, 7), new Position(0, 12)), DocumentHighlightKind.Write));
        highlights.add(new DocumentHighlight(new Range(new Position(0, 13), new Position(0, 17)), DocumentHighlightKind.Text));
        MockLanguageSever.INSTANCE.setDocumentHighlights(highlights);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "  READ WRITE TEXT");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        viewer.getTextWidget().setCaretOffset(1);
        if (!(viewer instanceof ISourceViewer)) {
            Assert.fail();
        }
        final ISourceViewer sourceViewer = (ISourceViewer)viewer;
        HashMap<org.eclipse.jface.text.Position, Annotation> annotations = new HashMap<org.eclipse.jface.text.Position, Annotation>();
        new DisplayHelper(){

            protected boolean condition() {
                return sourceViewer.getAnnotationModel().getAnnotationIterator().hasNext();
            }
        }.waitForCondition(Display.getCurrent(), 3000L);
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            annotation = (Annotation)iterator.next();
            annotations.put(model.getPosition(annotation), annotation);
        }
        annotation = (Annotation)annotations.get(new org.eclipse.jface.text.Position(2, 4));
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"org.eclipse.lsp4e.read", (Object)annotation.getType());
        annotation = (Annotation)annotations.get(new org.eclipse.jface.text.Position(7, 5));
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"org.eclipse.lsp4e.write", (Object)annotation.getType());
        annotation = (Annotation)annotations.get(new org.eclipse.jface.text.Position(13, 4));
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"org.eclipse.lsp4e.text", (Object)annotation.getType());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testCheckIfOtherAnnotationsRemains() throws CoreException, InvocationTargetException {
        Annotation annotation;
        this.checkGenericEditorVersion();
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "  READ WRITE TEXT");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        List<DocumentHighlight> highlights = Collections.singletonList(new DocumentHighlight(new Range(new Position(0, 2), new Position(0, 6)), DocumentHighlightKind.Read));
        MockLanguageSever.INSTANCE.setDocumentHighlights(highlights);
        if (!(viewer instanceof ISourceViewer)) {
            Assert.fail();
        }
        final ISourceViewer sourceViewer = (ISourceViewer)viewer;
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        String fakeAnnotationType = "FAKE_TYPE";
        Annotation fakeAnnotation = new Annotation(fakeAnnotationType, false, null);
        org.eclipse.jface.text.Position fakeAnnotationPosition = new org.eclipse.jface.text.Position(0, 10);
        model.addAnnotation(fakeAnnotation, fakeAnnotationPosition);
        viewer.getTextWidget().setCaretOffset(1);
        new DisplayHelper(){

            protected boolean condition() {
                Iterator iterator = sourceViewer.getAnnotationModel().getAnnotationIterator();
                AtomicInteger sum = new AtomicInteger(0);
                iterator.forEachRemaining(element -> {
                    int n = sum.incrementAndGet();
                });
                return sum.get() == 2;
            }
        }.waitForCondition(Display.getCurrent(), 3000L);
        Iterator iterator = model.getAnnotationIterator();
        HashMap<org.eclipse.jface.text.Position, Annotation> annotations = new HashMap<org.eclipse.jface.text.Position, Annotation>();
        while (iterator.hasNext()) {
            annotation = (Annotation)iterator.next();
            annotations.put(model.getPosition(annotation), annotation);
        }
        annotation = (Annotation)annotations.get(new org.eclipse.jface.text.Position(2, 4));
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"org.eclipse.lsp4e.read", (Object)annotation.getType());
        annotation = (Annotation)annotations.get(fakeAnnotationPosition);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)fakeAnnotationType, (Object)annotation.getType());
    }

    private void checkGenericEditorVersion() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.genericeditor");
        Assume.assumeTrue((bundle.getVersion().compareTo(new Version(1, 1, 0)) >= 0 ? 1 : 0) != 0);
    }
}

