/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.hover;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4e.operations.hover.LSBasedHover;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageSever;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HoverTest {
    private IProject project;
    private LSBasedHover hover;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("HoverTest" + System.currentTimeMillis());
        this.hover = new LSBasedHover();
    }

    @After
    public void tearDown() throws CoreException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        MockLanguageSever.INSTANCE.shutdown();
    }

    @Test
    public void testHoverRegion() throws CoreException, InvocationTargetException {
        Hover hoverResponse = new Hover(Collections.singletonList(Either.forLeft((Object)"HoverContent")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageSever.INSTANCE.setHover(hoverResponse);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Assert.assertEquals((Object)new Region(0, 10), (Object)this.hover.getHoverRegion(viewer, 5));
    }

    @Test
    public void testHoverRegionInvalidOffset() throws CoreException, InvocationTargetException {
        MockLanguageSever.INSTANCE.setHover(null);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Assert.assertEquals((Object)new Region(15, 0), (Object)this.hover.getHoverRegion(viewer, 15));
    }

    @Test
    public void testHoverInfo() throws CoreException, InvocationTargetException {
        Hover hoverResponse = new Hover(Collections.singletonList(Either.forLeft((Object)"HoverContent")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageSever.INSTANCE.setHover(hoverResponse);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Assert.assertTrue((boolean)this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 10)).contains("HoverContent"));
    }

    @Test
    public void testHoverInfoEmptyContentList() throws CoreException, InvocationTargetException {
        Hover hoverResponse = new Hover(Collections.emptyList(), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageSever.INSTANCE.setHover(hoverResponse);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Assert.assertEquals(null, (Object)this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 10)));
    }

    @Test
    public void testHoverInfoInvalidOffset() throws CoreException, InvocationTargetException {
        MockLanguageSever.INSTANCE.setHover(null);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Assert.assertEquals(null, (Object)this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 10)));
    }

    @Test
    public void testHoverEmptyContentItem() throws CoreException, InvocationTargetException {
        Hover hoverResponse = new Hover(Collections.singletonList(Either.forLeft((Object)"")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageSever.INSTANCE.setHover(hoverResponse);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Assert.assertEquals(null, (Object)this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 10)));
    }

    @Test
    public void testMultipleHovers() throws Exception {
        Hover hoverResponse = new Hover(Collections.singletonList(Either.forLeft((Object)"HoverContent")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageSever.INSTANCE.setHover(hoverResponse);
        IFile file = TestUtils.createUniqueTestFileMultiLS(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        String hoverInfo = this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 10));
        int index = hoverInfo.indexOf("HoverContent");
        Assert.assertNotEquals((String)"Hover content not found", (long)-1L, (long)index);
        index += "HoverContent".length();
        index = hoverInfo.indexOf("HoverContent", index);
        Assert.assertNotEquals((String)"Hover content found only once", (long)-1L, (long)index);
    }

    @Test
    public void testIntroUrlLink() throws Exception {
        Hover hoverResponse = new Hover(Collections.singletonList(Either.forLeft((Object)"[My intro URL link](http://org.eclipse.ui.intro/execute?command=org.eclipse.ui.file.close)")), new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageSever.INSTANCE.setHover(hoverResponse);
        IFile file = TestUtils.createUniqueTestFile(this.project, "HoverRange Other Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        String hoverContent = this.hover.getHoverInfo(viewer, (IRegion)new Region(0, 10));
        LSBasedHover hoverManager = new LSBasedHover();
        final Display display = PlatformUI.getWorkbench().getDisplay();
        Shell shell = new Shell(display);
        BrowserInformationControl wrapperControl = null;
        BrowserInformationControl control = null;
        try {
            RowLayout layout = new RowLayout(512);
            layout.fill = true;
            shell.setLayout((Layout)layout);
            shell.setSize(320, 200);
            shell.open();
            wrapperControl = (BrowserInformationControl)hoverManager.getHoverControlCreator().createInformationControl(shell);
            control = (BrowserInformationControl)wrapperControl.getInformationPresenterControlCreator().createInformationControl(shell);
            Field f = BrowserInformationControl.class.getDeclaredField("fBrowser");
            f.setAccessible(true);
            final Browser browser = (Browser)f.get(control);
            final AtomicBoolean completed = new AtomicBoolean(false);
            browser.addProgressListener((ProgressListener)new ProgressAdapter(){

                public void completed(ProgressEvent event) {
                    browser.removeProgressListener((ProgressListener)this);
                    browser.execute("document.getElementsByTagName('a')[0].click()");
                    while (display.readAndDispatch()) {
                    }
                    completed.set(true);
                }
            });
            Assert.assertNotNull((String)"Editor should be opened", (Object)viewer.getTextWidget());
            browser.setText(hoverContent);
            long maxTimestamp = System.currentTimeMillis() + 10000L;
            while (!completed.get() && System.currentTimeMillis() < maxTimestamp) {
                display.readAndDispatch();
            }
            Assert.assertNull((String)"Editor should be closed", (Object)viewer.getTextWidget());
        }
        finally {
            if (control != null) {
                control.dispose();
            }
            if (wrapperControl != null) {
                wrapperControl.dispose();
            }
            shell.dispose();
        }
    }
}

