/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.outline;

import org.eclipse.lsp4e.outline.SymbolsLabelProvider;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.junit.Assert;
import org.junit.Test;

public class SymbolsLabelProviderTest {
    private static final Location LOCATION = new Location("path/to/foo", new Range(new Position(0, 0), new Position(1, 1)));

    @Test
    public void testShowKind() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider();
        SymbolInformation info = new SymbolInformation("Foo", SymbolKind.Class, LOCATION);
        Assert.assertEquals((Object)"Foo :Class", (Object)labelProvider.getText((Object)info));
    }

    @Test
    public void testShowKindLocation() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(true, true);
        SymbolInformation info = new SymbolInformation("Foo", SymbolKind.Class, LOCATION);
        Assert.assertEquals((Object)"Foo :Class path/to/foo", (Object)labelProvider.getText((Object)info));
    }

    @Test
    public void testShowLocation() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(true, false);
        SymbolInformation info = new SymbolInformation("Foo", SymbolKind.Class, LOCATION);
        Assert.assertEquals((Object)"Foo path/to/foo", (Object)labelProvider.getText((Object)info));
    }

    @Test
    public void testShowNeither() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(false, false);
        SymbolInformation info = new SymbolInformation("Foo", SymbolKind.Class, LOCATION);
        Assert.assertEquals((Object)"Foo", (Object)labelProvider.getText((Object)info));
    }
}

