/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class CodeActionMarkerResolution
extends WorkbenchMarkerResolution
implements IMarkerResolution {
    private @NonNull Command command;

    public CodeActionMarkerResolution(@NonNull Command command) {
        this.command = command;
    }

    public String getLabel() {
        return this.command.getTitle();
    }

    public void run(IMarker marker) {
        String languageServerId;
        if (this.command.getArguments() == null) {
            return;
        }
        if (marker.getResource().getType() == 1 && (languageServerId = marker.getAttribute("languageServerId", null)) != null) {
            IFile file = (IFile)marker.getResource();
            LanguageServersRegistry.LanguageServerDefinition definition = LanguageServersRegistry.getInstance().getDefinition(languageServerId);
            if (file != null && definition != null) {
                try {
                    CompletableFuture<LanguageServer> languageServerFuture = LanguageServiceAccessor.getInitializedLanguageServer(file, definition, serverCapabilities -> {
                        ExecuteCommandOptions provider = serverCapabilities.getExecuteCommandProvider();
                        return provider != null && provider.getCommands().contains(this.command.getCommand());
                    });
                    if (languageServerFuture != null) {
                        languageServerFuture.thenAccept(server -> {
                            ExecuteCommandParams params = new ExecuteCommandParams();
                            params.setCommand(this.command.getCommand());
                            params.setArguments(this.command.getArguments());
                            server.getWorkspaceService().executeCommand(params);
                        });
                    }
                }
                catch (IOException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        WorkspaceEdit edit = LSPEclipseUtils.createWorkspaceEdit(this.command.getArguments(), marker.getResource());
        LSPEclipseUtils.applyWorkspaceEdit(edit);
    }

    public String getDescription() {
        return this.command.getTitle();
    }

    public Image getImage() {
        return null;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return new IMarker[0];
    }
}

