/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension7;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LSIncompleteCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6,
ICompletionProposalExtension7,
IContextInformation {
    private static final String TM_SELECTED_TEXT = "TM_SELECTED_TEXT";
    private static final String TM_CURRENT_LINE = "TM_CURRENT_LINE";
    private static final String TM_CURRENT_WORD = "TM_CURRENT_WORD";
    private static final String TM_LINE_INDEX = "TM_LINE_INDEX";
    private static final String TM_LINE_NUMBER = "TM_LINE_NUMBER";
    private static final String TM_FILENAME = "TM_FILENAME";
    private static final String TM_FILENAME_BASE = "TM_FILENAME_BASE";
    private static final String TM_DIRECTORY = "TM_DIRECTORY";
    private static final String TM_FILEPATH = "TM_FILEPATH";
    protected CompletionItem item;
    private int initialOffset = -1;
    protected int bestOffset = -1;
    protected ITextViewer viewer;
    private IRegion selection;
    private LinkedPosition firstPosition;
    private LanguageServiceAccessor.LSPDocumentInfo info;

    public LSIncompleteCompletionProposal(@NonNull CompletionItem item, int offset, LanguageServiceAccessor.LSPDocumentInfo info) {
        this.item = item;
        this.info = info;
        this.initialOffset = offset;
        this.bestOffset = this.getPrefixCompletionStart(info.getDocument(), offset);
    }

    public int getBestOffset() {
        return this.bestOffset;
    }

    public void updateOffset(int offset) {
        this.bestOffset = this.getPrefixCompletionStart(this.info.getDocument(), offset);
    }

    public CompletionItem getItem() {
        return this.item;
    }

    public StyledString getStyledDisplayString(IDocument document, int offset, BoldStylerProvider boldStylerProvider) {
        String rawString = this.getDisplayString();
        StyledString res = new StyledString(rawString);
        if (offset > this.bestOffset) {
            try {
                String subString = document.get(this.bestOffset, offset - this.bestOffset);
                if (this.item.getTextEdit() != null) {
                    int start = LSPEclipseUtils.toOffset(this.item.getTextEdit().getRange().getStart(), document);
                    int end = offset;
                    subString = document.get(start, end - start);
                }
                int lastIndex = 0;
                subString = subString.toLowerCase();
                String lowerRawString = rawString.toLowerCase();
                char[] cArray = subString.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Character c = Character.valueOf(cArray[n2]);
                    int index = lowerRawString.indexOf(c.charValue(), lastIndex);
                    if (index < 0) {
                        return res;
                    }
                    res.setStyle(index, 1, boldStylerProvider.getBoldStyler());
                    lastIndex = index + 1;
                    ++n2;
                }
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return res;
    }

    public String getDisplayString() {
        return this.item.getLabel();
    }

    public StyledString getStyledDisplayString() {
        return new StyledString(this.getDisplayString());
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            public IInformationControl doCreateInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, true);
            }
        };
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        CompletionOptions options;
        ServerCapabilities capabilities = this.info.getCapabilites();
        if (capabilities != null && (options = capabilities.getCompletionProvider()) != null && Boolean.TRUE.equals(options.getResolveProvider())) {
            try {
                this.updateCompletionItem((CompletionItem)((CompletableFuture)this.info.getInitializedLanguageClient().thenCompose(ls -> ls.getTextDocumentService().resolveCompletionItem(this.item))).get(500L, TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        StringBuilder res = new StringBuilder();
        if (this.item.getDetail() != null) {
            res.append("<p>" + this.item.getDetail() + "</p>");
        }
        if (res.length() > 0) {
            res.append("<br/>");
        }
        if (this.item.getDocumentation() != null) {
            res.append("<p>" + LSPEclipseUtils.getDocString((Either<String, MarkupContent>)this.item.getDocumentation()) + "</p>");
        }
        return res.toString();
    }

    private void updateCompletionItem(CompletionItem resolvedItem) {
        if (resolvedItem == null) {
            return;
        }
        if (resolvedItem.getLabel() != null) {
            this.item.setLabel(resolvedItem.getLabel());
        }
        if (resolvedItem.getKind() != null) {
            this.item.setKind(resolvedItem.getKind());
        }
        if (resolvedItem.getDetail() != null) {
            this.item.setDetail(resolvedItem.getDetail());
        }
        if (resolvedItem.getDocumentation() != null) {
            this.item.setDocumentation(resolvedItem.getDocumentation());
        }
        if (resolvedItem.getInsertText() != null) {
            this.item.setInsertText(resolvedItem.getInsertText());
        }
        if (resolvedItem.getInsertTextFormat() != null) {
            this.item.setInsertTextFormat(resolvedItem.getInsertTextFormat());
        }
        if (resolvedItem.getTextEdit() != null) {
            this.item.setTextEdit(resolvedItem.getTextEdit());
        }
        if (resolvedItem.getAdditionalTextEdits() != null) {
            this.item.setAdditionalTextEdits(resolvedItem.getAdditionalTextEdits());
        }
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.item.getInsertText().substring(completionOffset - this.bestOffset);
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        if (this.item.getTextEdit() != null) {
            try {
                return LSPEclipseUtils.toOffset(this.item.getTextEdit().getRange().getStart(), document);
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        String insertText = this.getInsertText();
        try {
            String subDoc = document.get(Math.max(0, completionOffset - insertText.length()), Math.min(insertText.length(), completionOffset));
            int i = 0;
            while (i < insertText.length() && i < completionOffset) {
                String tentativeCommonString = subDoc.substring(i);
                if (insertText.startsWith(tentativeCommonString)) {
                    return completionOffset - tentativeCommonString.length();
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return completionOffset;
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', 0, this.bestOffset);
    }

    protected void apply(IDocument document, char trigger, int stateMask, int offset) {
        String insertText = null;
        TextEdit textEdit = this.item.getTextEdit();
        try {
            Position end;
            Position start;
            if (textEdit == null) {
                insertText = this.getInsertText();
                start = LSPEclipseUtils.toPosition(this.bestOffset, document);
                end = LSPEclipseUtils.toPosition(offset, document);
                textEdit = new TextEdit(new Range(start, end), insertText);
            } else if (offset > this.initialOffset) {
                int shift = offset - this.initialOffset;
                textEdit.getRange().getEnd().setCharacter(textEdit.getRange().getEnd().getCharacter() + shift);
            }
            start = textEdit.getRange().getStart();
            end = textEdit.getRange().getEnd();
            if (start.getLine() > end.getLine() || start.getLine() == end.getLine() && start.getCharacter() > end.getCharacter()) {
                textEdit.getRange().setEnd(start);
                textEdit.getRange().setStart(end);
            }
            Position documentEnd = LSPEclipseUtils.toPosition(document.getLength(), document);
            Position textEditEnd = textEdit.getRange().getEnd();
            if (documentEnd.getLine() < textEditEnd.getLine() || documentEnd.getLine() == textEditEnd.getLine() && documentEnd.getCharacter() < textEditEnd.getCharacter()) {
                textEdit.getRange().setEnd(documentEnd);
            }
            if (insertText != null) {
                int shift = offset - this.bestOffset;
                int commonSize = 0;
                while (commonSize < insertText.length() - shift && document.getLength() > offset + commonSize && document.getChar(this.bestOffset + shift + commonSize) == insertText.charAt(commonSize + shift)) {
                    ++commonSize;
                }
                textEdit.getRange().getEnd().setCharacter(textEdit.getRange().getEnd().getCharacter() + commonSize);
            }
            insertText = textEdit.getNewText();
            LinkedHashMap regions = new LinkedHashMap();
            int insertionOffset = LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document);
            insertionOffset = this.computeNewOffset(this.item.getAdditionalTextEdits(), insertionOffset, document);
            if (this.item.getInsertTextFormat() == InsertTextFormat.Snippet) {
                int currentOffset = 0;
                while ((currentOffset = insertText.indexOf(36, currentOffset)) != -1) {
                    StringBuilder keyBuilder = new StringBuilder();
                    String defaultValue = "";
                    int length = 1;
                    while (currentOffset + length < insertText.length() && Character.isDigit(insertText.charAt(currentOffset + length))) {
                        keyBuilder.append(insertText.charAt(currentOffset + length));
                        ++length;
                    }
                    if (length == 1 && insertText.length() >= 2 && insertText.charAt(currentOffset + 1) == '{') {
                        String varValue;
                        ++length;
                        while (currentOffset + length < insertText.length() && Character.isDigit(insertText.charAt(currentOffset + length))) {
                            keyBuilder.append(insertText.charAt(currentOffset + length));
                            ++length;
                        }
                        if (currentOffset + length < insertText.length() && insertText.charAt(currentOffset + length) == ':') {
                            ++length;
                        }
                        while (currentOffset + length < insertText.length() && insertText.charAt(currentOffset + length) != '}') {
                            defaultValue = String.valueOf(defaultValue) + insertText.charAt(currentOffset + length);
                            ++length;
                        }
                        if (defaultValue.startsWith("$") && (varValue = this.getVariableValue(defaultValue.substring(1))) != null) {
                            defaultValue = varValue;
                        }
                        if (currentOffset + length < insertText.length() && insertText.charAt(currentOffset + length) == '}') {
                            ++length;
                        }
                    }
                    if (keyBuilder.length() > 0) {
                        String key = keyBuilder.toString();
                        if (!regions.containsKey(key)) {
                            regions.put(key, new ArrayList());
                        }
                        insertText = String.valueOf(insertText.substring(0, currentOffset)) + defaultValue + insertText.substring(currentOffset + length);
                        LinkedPosition position = new LinkedPosition(document, insertionOffset + currentOffset, defaultValue.length());
                        if (this.firstPosition == null) {
                            this.firstPosition = position;
                        }
                        ((List)regions.get(key)).add(position);
                        currentOffset += defaultValue.length();
                        continue;
                    }
                    ++currentOffset;
                }
            }
            textEdit.setNewText(insertText);
            List additionalEdits = this.item.getAdditionalTextEdits();
            if (additionalEdits != null && !additionalEdits.isEmpty()) {
                ImmutableList.Builder allEdits = ImmutableList.builder();
                allEdits.add((Object)textEdit);
                allEdits.addAll((Iterable)additionalEdits);
                LSPEclipseUtils.applyEdits(document, (List<? extends TextEdit>)allEdits.build());
            } else {
                LSPEclipseUtils.applyEdit(textEdit, document);
            }
            if (this.viewer != null && !regions.isEmpty()) {
                LinkedModeModel model = new LinkedModeModel();
                for (List positions : regions.values()) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    for (LinkedPosition position : positions) {
                        group.addPosition(position);
                    }
                    model.addGroup(group);
                }
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.viewer);
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.enter();
            } else {
                this.selection = new Region(insertionOffset + textEdit.getNewText().length(), 0);
            }
        }
        catch (BadLocationException ex) {
            LanguageServerPlugin.logError(ex);
        }
    }

    private int computeNewOffset(List<TextEdit> additionalTextEdits, int insertionOffset, IDocument doc) {
        if (additionalTextEdits != null && !additionalTextEdits.isEmpty()) {
            int adjustment = 0;
            for (TextEdit edit : additionalTextEdits) {
                try {
                    Range rng = edit.getRange();
                    int start = LSPEclipseUtils.toOffset(rng.getStart(), doc);
                    if (start > insertionOffset) continue;
                    int end = LSPEclipseUtils.toOffset(rng.getEnd(), doc);
                    int orgLen = end - start;
                    int newLeng = edit.getNewText().length();
                    int editChange = newLeng - orgLen;
                    adjustment += editChange;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
            return insertionOffset + adjustment;
        }
        return insertionOffset;
    }

    private String getVariableValue(String variableName) {
        switch (variableName) {
            case "TM_FILENAME_BASE": {
                IPath pathBase = Path.fromPortableString((String)this.info.getFileUri().getPath()).removeFileExtension();
                String fileName = pathBase.lastSegment();
                return fileName != null ? fileName : "";
            }
            case "TM_FILENAME": {
                return Path.fromPortableString((String)this.info.getFileUri().getPath()).lastSegment();
            }
            case "TM_FILEPATH": {
                IResource resource = LSPEclipseUtils.findResourceFor(this.info.getFileUri().toString());
                if (resource != null) {
                    return resource.getLocation().toString();
                }
                return "";
            }
            case "TM_DIRECTORY": {
                IResource dirResource = LSPEclipseUtils.findResourceFor(this.info.getFileUri().toString());
                if (dirResource != null && dirResource.getParent() != null) {
                    return dirResource.getParent().getLocation().toString();
                }
                return "";
            }
            case "TM_LINE_INDEX": {
                int lineIndex = this.item.getTextEdit().getRange().getStart().getLine();
                return Integer.toString(lineIndex);
            }
            case "TM_LINE_NUMBER": {
                int lineNumber = this.item.getTextEdit().getRange().getStart().getLine();
                return Integer.toString(lineNumber + 1);
            }
            case "TM_CURRENT_LINE": {
                int currentLineIndex = this.item.getTextEdit().getRange().getStart().getLine();
                try {
                    IRegion lineInformation = this.info.getDocument().getLineInformation(currentLineIndex);
                    String line = this.info.getDocument().get(lineInformation.getOffset(), lineInformation.getLength());
                    return line;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logWarning(e.getMessage(), e);
                    return "";
                }
            }
            case "TM_SELECTED_TEXT": {
                Range selectedRange = this.item.getTextEdit().getRange();
                try {
                    int startOffset = LSPEclipseUtils.toOffset(selectedRange.getStart(), this.info.getDocument());
                    int endOffset = LSPEclipseUtils.toOffset(selectedRange.getEnd(), this.info.getDocument());
                    String selectedText = this.info.getDocument().get(startOffset, endOffset - startOffset);
                    return selectedText;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logWarning(e.getMessage(), e);
                    return "";
                }
            }
            case "TM_CURRENT_WORD": {
                return "";
            }
        }
        return null;
    }

    protected String getInsertText() {
        String insertText = this.item.getInsertText();
        if (this.item.getTextEdit() != null) {
            insertText = this.item.getTextEdit().getNewText();
        }
        if (insertText == null) {
            insertText = this.item.getLabel();
        }
        return insertText;
    }

    public Point getSelection(IDocument document) {
        if (this.firstPosition != null) {
            return new Point(this.firstPosition.getOffset(), this.firstPosition.getLength());
        }
        if (this.selection == null) {
            return null;
        }
        return new Point(this.selection.getOffset(), this.selection.getLength());
    }

    public String getAdditionalProposalInfo() {
        return this.item.getDetail();
    }

    public Image getImage() {
        return LSPImages.imageFromCompletionItem(this.item);
    }

    public IContextInformation getContextInformation() {
        return this;
    }

    public String getContextDisplayString() {
        return this.getAdditionalProposalInfo();
    }

    public String getInformationDisplayString() {
        return this.getAdditionalProposalInfo();
    }

    public String getSortText() {
        if (this.item.getSortText() != null && !this.item.getSortText().isEmpty()) {
            return this.item.getSortText();
        }
        return this.item.getLabel();
    }

    public int getNumberOfModifsBeforeOffset() {
        if (this.item.getTextEdit() == null) {
            return 0;
        }
        int res = 0;
        try {
            int startOffset = LSPEclipseUtils.toOffset(this.item.getTextEdit().getRange().getStart(), this.info.getDocument());
            String insert = this.item.getTextEdit().getNewText();
            String subDoc = this.info.getDocument().get(startOffset, Math.min(startOffset + insert.length(), this.info.getDocument().getLength() - startOffset));
            int i = 0;
            while (i < subDoc.length() && i < insert.length()) {
                if (subDoc.charAt(i) != insert.charAt(i)) {
                    ++res;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return res;
    }
}

