/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.diagnostics;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class LSPDiagnosticsToMarkers
implements Consumer<PublishDiagnosticsParams> {
    public static final String LSP_DIAGNOSTIC = "lspDiagnostic";
    public static final String LANGUAGE_SERVER_ID = "languageServerId";
    public static final String LS_DIAGNOSTIC_MARKER_TYPE = "org.eclipse.lsp4e.diagnostic";
    private final @NonNull String languageServerId;

    public LSPDiagnosticsToMarkers(@NonNull String serverId) {
        this.languageServerId = serverId;
    }

    @Deprecated
    public LSPDiagnosticsToMarkers(IProject project, @NonNull String serverId) {
        this(serverId);
    }

    @Override
    public void accept(PublishDiagnosticsParams diagnostics) {
        try {
            String uri = diagnostics.getUri();
            IResource resource = LSPEclipseUtils.findResourceFor(uri);
            if (resource == null || !resource.exists()) {
                return;
            }
            HashSet<IMarker> remainingMarkers = new HashSet<IMarker>(Arrays.asList(resource.findMarkers(LS_DIAGNOSTIC_MARKER_TYPE, false, 1)));
            remainingMarkers.removeIf(marker -> !Objects.equals(marker.getAttribute(LANGUAGE_SERVER_ID, ""), this.languageServerId));
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                IMarker associatedMarker = this.getExistingMarkerFor(resource, diagnostic, remainingMarkers);
                if (associatedMarker == null) {
                    associatedMarker = resource.createMarker(LS_DIAGNOSTIC_MARKER_TYPE);
                } else {
                    remainingMarkers.remove(associatedMarker);
                }
                this.updateMarker(resource, diagnostic, associatedMarker);
            }
            for (IMarker marker2 : remainingMarkers) {
                marker2.delete();
            }
        }
        catch (CoreException ex) {
            LanguageServerPlugin.logError(ex);
        }
    }

    protected void updateMarker(IResource resource, Diagnostic diagnostic, IMarker marker) {
        try {
            marker.setAttribute(LSP_DIAGNOSTIC, (Object)diagnostic);
            marker.setAttribute(LANGUAGE_SERVER_ID, (Object)this.languageServerId);
            marker.setAttribute("message", (Object)diagnostic.getMessage());
            marker.setAttribute("severity", LSPEclipseUtils.toEclipseMarkerSeverity(diagnostic.getSeverity()));
            if (resource.getType() != 1) {
                return;
            }
            IFile file = (IFile)resource;
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = manager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            if (textFileBuffer == null) {
                manager.connect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                textFileBuffer = manager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            }
            IDocument document = textFileBuffer.getDocument();
            int start = Math.min(LSPEclipseUtils.toOffset(diagnostic.getRange().getStart(), document), document.getLength());
            int end = Math.min(LSPEclipseUtils.toOffset(diagnostic.getRange().getEnd(), document), document.getLength());
            marker.setAttribute("charStart", start);
            marker.setAttribute("charEnd", end);
            marker.setAttribute("lineNumber", document.getLineOfOffset(start) + 1);
        }
        catch (CoreException | BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    private IMarker getExistingMarkerFor(IResource resource, Diagnostic diagnostic, Set<IMarker> remainingMarkers) {
        ITextFileBuffer textFileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
        if (textFileBuffer == null) {
            return null;
        }
        IDocument document = textFileBuffer.getDocument();
        for (IMarker marker : remainingMarkers) {
            int startOffset = MarkerUtilities.getCharStart((IMarker)marker);
            int endOffset = MarkerUtilities.getCharEnd((IMarker)marker);
            try {
                if (!marker.getResource().getProjectRelativePath().toString().equals(diagnostic.getSource()) || LSPEclipseUtils.toOffset(diagnostic.getRange().getStart(), document) != startOffset + 1 || LSPEclipseUtils.toOffset(diagnostic.getRange().getEnd(), document) != endOffset + 1 || !Objects.equals(marker.getAttribute("message"), diagnostic.getMessage()) || !Objects.equals(marker.getAttribute(LANGUAGE_SERVER_ID), this.languageServerId)) continue;
                return marker;
            }
            catch (CoreException | BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return null;
    }
}

