/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.highlight;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;

public class HighlightReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
CaretListener,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String TOGGLE_HIGHLIGHT_PREFERENCE = "org.eclipse.ui.genericeditor.togglehighlight";
    public static final String READ_ANNOTATION_TYPE = "org.eclipse.lsp4e.read";
    public static final String WRITE_ANNOTATION_TYPE = "org.eclipse.lsp4e.write";
    public static final String TEXT_ANNOTATION_TYPE = "org.eclipse.lsp4e.text";
    private boolean enabled;
    private ISourceViewer sourceViewer;
    private IDocument document;
    private CompletableFuture<List<? extends DocumentHighlight>> request;
    private List<LanguageServiceAccessor.LSPDocumentInfo> infos;
    private Annotation[] fOccurrenceAnnotations = null;

    public void install(ITextViewer viewer) {
        if (!(viewer instanceof ISourceViewer)) {
            return;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.enabled = preferences.getBoolean(TOGGLE_HIGHLIGHT_PREFERENCE, true);
        this.sourceViewer = (ISourceViewer)viewer;
        this.sourceViewer.getTextWidget().addCaretListener((CaretListener)this);
    }

    public void uninstall() {
        if (this.sourceViewer != null) {
            this.sourceViewer.getTextWidget().removeCaretListener((CaretListener)this);
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.cancel();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        StyledText textWidget;
        if (this.sourceViewer != null && (textWidget = this.sourceViewer.getTextWidget()) != null) {
            textWidget.getDisplay().asyncExec(() -> {
                if (!textWidget.isDisposed()) {
                    this.collectHighlights(textWidget.getCaretOffset());
                }
            });
        }
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void caretMoved(CaretEvent event) {
        Job.createSystem((String)"LSP4E Highlight", monitor -> this.collectHighlights(caretEvent.caretOffset)).schedule();
    }

    private void collectHighlights(int caretOffset) {
        if (this.sourceViewer == null || !this.enabled) {
            return;
        }
        if (this.infos == null) {
            this.infos = LanguageServiceAccessor.getLSPDocumentInfosFor(this.document, capabilities -> Boolean.TRUE.equals(capabilities.getDocumentHighlightProvider()));
        }
        if (this.infos.isEmpty()) {
            return;
        }
        this.cancel();
        try {
            Position position = LSPEclipseUtils.toPosition(caretOffset, this.document);
            for (LanguageServiceAccessor.LSPDocumentInfo info : this.infos) {
                TextDocumentIdentifier identifier = new TextDocumentIdentifier(info.getFileUri().toString());
                TextDocumentPositionParams params = new TextDocumentPositionParams(identifier, position);
                this.request = info.getInitializedLanguageClient().thenCompose(languageServer -> languageServer.getTextDocumentService().documentHighlight(params));
                this.request.thenAccept(result -> this.updateAnnotations((List<? extends DocumentHighlight>)result, this.sourceViewer.getAnnotationModel()));
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    private void cancel() {
        if (this.request != null && !this.request.isDone()) {
            this.request.cancel(true);
            this.request = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnnotations(List<? extends DocumentHighlight> highlights, IAnnotationModel annotationModel) {
        HashMap<Annotation, org.eclipse.jface.text.Position> annotationMap = new HashMap<Annotation, org.eclipse.jface.text.Position>(highlights.size());
        for (DocumentHighlight object : highlights) {
            if (object == null) continue;
            try {
                int start = LSPEclipseUtils.toOffset(object.getRange().getStart(), this.document);
                int end = LSPEclipseUtils.toOffset(object.getRange().getEnd(), this.document);
                annotationMap.put(new Annotation(this.kindToAnnotationType(object.getKind()), false, null), new org.eclipse.jface.text.Position(start, end - start));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, annotationMap);
            } else {
                this.removeOccurrenceAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (org.eclipse.jface.text.Position)mapEntry.getValue());
                }
            }
            this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        IAnnotationModel annotationModel = this.sourceViewer.getAnnotationModel();
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                Annotation[] annotationArray = this.fOccurrenceAnnotations;
                int n = this.fOccurrenceAnnotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation fOccurrenceAnnotation = annotationArray[n2];
                    annotationModel.removeAnnotation(fOccurrenceAnnotation);
                    ++n2;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    private String kindToAnnotationType(DocumentHighlightKind kind) {
        switch (kind) {
            case Read: {
                return READ_ANNOTATION_TYPE;
            }
            case Write: {
                return WRITE_ANNOTATION_TYPE;
            }
        }
        return TEXT_ANNOTATION_TYPE;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(TOGGLE_HIGHLIGHT_PREFERENCE)) {
            this.enabled = Boolean.valueOf(event.getNewValue().toString());
            if (this.enabled) {
                this.initialReconcile();
            } else {
                this.removeOccurrenceAnnotations();
            }
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void reconcile(IRegion partition) {
    }
}

